/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractSearchSet;
import dev.dsf.fhir.adapter.ElementId;
import java.util.regex.Pattern;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Resource;

public class SearchSetMeasureReport
extends AbstractSearchSet<MeasureReport> {
    private static final String MEASURE_URL_PATTERN_STRING = "((http|https):\\/\\/([A-Za-z0-9\\-\\\\\\.\\:\\%\\$]*\\/)+)?Measure\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?";
    private static final Pattern MEASURE_URL_PATTERN = Pattern.compile("((http|https):\\/\\/([A-Za-z0-9\\-\\\\\\.\\:\\%\\$]*\\/)+)?Measure\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?");

    public SearchSetMeasureReport(int defaultPageCount) {
        super(defaultPageCount, MeasureReport.class);
    }

    protected Row toRow(ElementId id, MeasureReport resource) {
        String status = this.getEnumeration(resource, MeasureReport::hasStatusElement, MeasureReport::getStatusElement);
        String type = this.getEnumeration(resource, MeasureReport::hasTypeElement, MeasureReport::getTypeElement);
        String date = this.getDateTime(resource, MeasureReport::hasDateElement, MeasureReport::getDateElement);
        String measureCanonical = resource.hasMeasureElement() && resource.getMeasureElement().hasValue() ? (String)resource.getMeasureElement().getValue() : null;
        ElementId measure = measureCanonical != null && MEASURE_URL_PATTERN.matcher(measureCanonical).matches() ? ElementId.from((IIdType)new IdType(measureCanonical)) : null;
        String lastUpdated = this.formatLastUpdated((Resource)resource);
        return new Row(id, status, type, date, measure, lastUpdated);
    }

    private record Row(ElementId id, String status, String type, String date, ElementId measure, String lastUpdated) {
    }
}

