/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractSearchSet;
import dev.dsf.fhir.adapter.ElementId;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Resource;

public class SearchSetEndpoint
extends AbstractSearchSet<Endpoint> {
    public SearchSetEndpoint(int defaultPageCount) {
        super(defaultPageCount, Endpoint.class);
    }

    protected Row toRow(ElementId id, Endpoint resource) {
        String status = resource.hasStatus() ? resource.getStatus().toCode() : "";
        String identifier = this.getIdentifierValues(resource, Endpoint::hasIdentifier, Endpoint::getIdentifier, "http://dsf.dev/sid/endpoint-identifier");
        String name = resource.hasName() ? resource.getName() : "";
        String address = resource.hasAddress() ? resource.getAddress() : "";
        ElementId managingOrganization = ElementId.from(resource, Endpoint::hasManagingOrganization, Endpoint::getManagingOrganization);
        String lastUpdated = this.formatLastUpdated((Resource)resource);
        return new Row(id, status, identifier, name, address, managingOrganization, lastUpdated);
    }

    private record Row(ElementId id, String status, String identifier, String name, String address, ElementId managingOrganization, String lastUpdated) {
    }
}

