/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractSearchSet;
import dev.dsf.fhir.adapter.ElementId;
import java.util.List;
import java.util.regex.Matcher;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;

public class SearchSetActivityDefinition
extends AbstractSearchSet<ActivityDefinition> {
    public SearchSetActivityDefinition(int defaultPageCount) {
        super(defaultPageCount, ActivityDefinition.class);
    }

    protected Row toRow(ElementId id, ActivityDefinition resource) {
        List<String> messageNames;
        Matcher matcher;
        String status = resource.hasStatus() ? resource.getStatus().toCode() : "";
        String title = resource.hasTitleElement() && resource.getTitleElement().hasValue() ? (String)resource.getTitleElement().getValue() : "";
        String processDomain = "";
        String processName = "";
        String processVersion = "";
        if (resource.getUrl() != null && !resource.getUrl().isBlank() && (matcher = INSTANTIATES_CANONICAL_PATTERN.matcher(resource.getUrl() + (String)(resource.hasVersion() ? "|" + resource.getVersion() : ""))).matches()) {
            processDomain = matcher.group("domain");
            processName = matcher.group("processName");
            processVersion = matcher.group("processVersion");
        }
        String combinedMessageNames = (messageNames = resource.getExtensionsByUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization").stream().flatMap(e -> e.getExtensionsByUrl("message-name").stream()).filter(e -> e.getValue() instanceof StringType).map(e -> (String)((StringType)e.getValue()).getValue()).toList()).size() > 2 ? String.join((CharSequence)", ", messageNames.subList(0, 2)) + ", ..." : String.join((CharSequence)", ", messageNames);
        String lastUpdated = this.formatLastUpdated((Resource)resource);
        return new Row(id, status, title, processDomain, processName, processVersion, combinedMessageNames, lastUpdated);
    }

    private record Row(ElementId id, String status, String title, String processDomain, String processName, String processVersion, String messageNames, String lastUpdated) {
    }
}

