/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import dev.dsf.fhir.adapter.AbstractResource;
import dev.dsf.fhir.adapter.ElementSystemValue;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTask
extends AbstractResource<Task> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceTask.class);
    private static final String CODESYSTEM_DSF_BPMN_MESSAGE = "http://dsf.dev/fhir/CodeSystem/bpmn-message";
    private static final String CODESYSTEM_DSF_BPMN_MESSAGE_VALUE_MESSAGE_NAME = "message-name";
    private static final String CODESYSTEM_DSF_BPMN_MESSAGE_VALUE_BUSINESS_KEY = "business-key";
    private static final String CODESYSTEM_DSF_BPMN_MESSAGE_VALUE_CORRELATION_KEY = "correlation-key";
    private static final List<String> FILTERD_INPUTS = List.of("message-name", "business-key", "correlation-key");
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    public ResourceTask() {
        super(Task.class, AbstractResource.ActiveOrStatus.status(Task::hasStatusElement, Task::getStatusElement));
    }

    @Override
    protected void doSetAdditionalVariables(BiConsumer<String, Object> variables, Task resource) {
        variables.accept("form", true);
    }

    protected Element toElement(Task resource) {
        String process = resource.hasInstantiatesCanonicalElement() && resource.getInstantiatesCanonicalElement().hasValue() ? ((String)resource.getInstantiatesCanonicalElement().getValue()).replace("|", " | ") : null;
        String messageName = this.getFirstInputParameter(resource, CODESYSTEM_DSF_BPMN_MESSAGE, CODESYSTEM_DSF_BPMN_MESSAGE_VALUE_MESSAGE_NAME);
        String businessKey = this.getFirstInputParameter(resource, CODESYSTEM_DSF_BPMN_MESSAGE, CODESYSTEM_DSF_BPMN_MESSAGE_VALUE_BUSINESS_KEY);
        String correlationKey = this.getFirstInputParameter(resource, CODESYSTEM_DSF_BPMN_MESSAGE, CODESYSTEM_DSF_BPMN_MESSAGE_VALUE_CORRELATION_KEY);
        ElementSystemValue requester = resource.hasRequester() && resource.getRequester().hasIdentifier() ? ElementSystemValue.from(resource.getRequester().getIdentifier()) : null;
        ElementSystemValue recipient = resource.hasRestriction() && resource.getRestriction().hasRecipient() && resource.getRestriction().getRecipient().size() == 1 && resource.getRestriction().getRecipientFirstRep().hasIdentifier() ? ElementSystemValue.from(resource.getRestriction().getRecipientFirstRep().getIdentifier()) : null;
        String authoredOn = resource.hasAuthoredOnElement() && resource.getAuthoredOnElement().hasValue() ? this.formatDateTime((Date)resource.getAuthoredOnElement().getValue()) : null;
        HashMap<String, Integer> idCounter = new HashMap<String, Integer>();
        List<InputItem> input = resource.hasInput() ? resource.getInput().stream().filter(Task.ParameterComponent::hasType).filter(i -> i.getType().hasCoding()).filter(i -> i.getType().getCoding().stream().filter(Coding::hasSystemElement).filter(Coding::hasCodeElement).filter(c -> c.getSystemElement().hasValue()).filter(c -> c.getCodeElement().hasValue()).anyMatch(c -> !CODESYSTEM_DSF_BPMN_MESSAGE.equals(c.getSystemElement().getValue()) || !CODESYSTEM_DSF_BPMN_MESSAGE.equals(c.getSystemElement().getValue()) || !FILTERD_INPUTS.contains(c.getCodeElement().getValue()))).map(this.toInputItem(idCounter)).filter(i -> i != null).toList() : List.of();
        List<OutputItem> output = resource.hasOutput() ? resource.getOutput().stream().filter(Task.TaskOutputComponent::hasType).filter(i -> i.getType().hasCoding()).filter(i -> i.getType().getCoding().stream().filter(Coding::hasSystemElement).filter(Coding::hasCodeElement).anyMatch(c -> c.getSystemElement().hasValue() && c.getCodeElement().hasValue())).map(this::toOutputItem).filter(i -> i != null).toList() : List.of();
        return new Element(process, messageName, businessKey, correlationKey, requester, recipient, authoredOn, input, output);
    }

    private String getFirstInputParameter(Task task, String system, String code) {
        return task.getInput().stream().filter(Task.ParameterComponent::hasType).filter(c -> c.getType().hasCoding()).filter(c -> c.getType().getCoding().stream().anyMatch(co -> Objects.equals(system, co.getSystem()) && Objects.equals(code, co.getCode()))).filter(Task.ParameterComponent::hasValue).map(Task.ParameterComponent::getValue).filter(v -> v instanceof StringType).map(v -> (StringType)v).map(PrimitiveType::getValue).findFirst().orElse(null);
    }

    private Function<Task.ParameterComponent, InputItem> toInputItem(Map<String, Integer> idCounter) {
        return i -> {
            Object id = i.hasType() && i.getType().hasCoding() ? (String)i.getType().getCoding().stream().filter(Coding::hasSystemElement).filter(c -> c.getSystemElement().hasValue()).filter(Coding::hasCodeElement).filter(c -> c.getCodeElement().hasValue()).findFirst().map(c -> (String)c.getSystemElement().getValue() + "|" + (String)c.getCodeElement().getValue()).orElse(null) : null;
            String labelTitle = id;
            if (idCounter.containsKey(id)) {
                int count = (Integer)idCounter.get(id) + 1;
                idCounter.put((String)id, count);
                id = (String)id + "|" + count;
            } else {
                idCounter.put((String)id, 0);
            }
            String label = i.hasType() && i.getType().hasCoding() ? (String)i.getType().getCoding().stream().filter(Coding::hasSystemElement).filter(c -> c.getSystemElement().hasValue()).filter(Coding::hasCodeElement).filter(c -> c.getCodeElement().hasValue()).findFirst().map(c -> (String)c.getCodeElement().getValue()).orElse(null) : null;
            return this.toItem((String)id, label, labelTitle, i.getValue());
        };
    }

    private InputItem toItem(String id, String label, String labelTitle, Type typedValue) {
        String type = this.getHtmlInputType(typedValue);
        String fhirType = this.getFhirType(typedValue);
        String stringValue = this.getStringValue(typedValue);
        ElementSystemValue systemValueValue = this.getSystemValueValue(typedValue);
        Boolean booleanValue = this.getBooleanValue(typedValue);
        if (stringValue == null && systemValueValue == null && booleanValue == null) {
            logger.warn("Output parameter with {} value, not supported", (Object)fhirType);
        }
        return new InputItem(id, type, label, labelTitle, fhirType, stringValue, systemValueValue, booleanValue);
    }

    private OutputItem toOutputItem(Task.TaskOutputComponent o) {
        String labelTitle = o.hasType() && o.getType().hasCoding() ? (String)o.getType().getCoding().stream().filter(Coding::hasSystemElement).filter(c -> c.getSystemElement().hasValue()).filter(Coding::hasCodeElement).filter(c -> c.getCodeElement().hasValue()).findFirst().map(c -> (String)c.getSystemElement().getValue() + "|" + (String)c.getCodeElement().getValue()).orElse(null) : null;
        String label = o.hasType() && o.getType().hasCoding() ? (String)o.getType().getCoding().stream().filter(Coding::hasSystemElement).filter(c -> c.getSystemElement().hasValue()).filter(Coding::hasCodeElement).filter(c -> c.getCodeElement().hasValue()).findFirst().map(c -> (String)c.getCodeElement().getValue()).orElse(null) : null;
        List<ExtensionItem> extension = o.hasExtension() ? this.toExtensionItems(o.getExtension()) : List.of();
        return this.toOutputItem(label, labelTitle, o.getValue(), extension);
    }

    private OutputItem toOutputItem(String label, String labelTitle, Type typedValue, List<ExtensionItem> extension) {
        String type = this.getHtmlInputType(typedValue);
        String stringValue = this.getStringValue(typedValue);
        ElementSystemValue systemValueValue = this.getSystemValueValue(typedValue);
        Boolean booleanValue = this.getBooleanValue(typedValue);
        if (stringValue == null && systemValueValue == null && booleanValue == null) {
            logger.warn("Output parameter with {} value, not supported", (Object)typedValue.getClass().getAnnotation(DatatypeDef.class).name());
        }
        return new OutputItem(UUID.randomUUID().toString(), type, label, labelTitle, stringValue, systemValueValue, booleanValue, extension);
    }

    private String getHtmlInputType(Type typedValue) {
        Reference r;
        Reference r2;
        if (typedValue instanceof BooleanType) {
            return "boolean";
        }
        if (typedValue instanceof DecimalType) {
            return "number";
        }
        if (typedValue instanceof IntegerType) {
            return "number";
        }
        if (typedValue instanceof DateType) {
            return "date";
        }
        if (typedValue instanceof DateTimeType) {
            return "datetime-local";
        }
        if (typedValue instanceof TimeType) {
            return "time";
        }
        if (typedValue instanceof InstantType) {
            return "datetime-local";
        }
        if (typedValue instanceof StringType) {
            return "text";
        }
        if (typedValue instanceof UriType) {
            return "url";
        }
        if (typedValue instanceof Coding) {
            return "coding";
        }
        if (typedValue instanceof Identifier) {
            return "identifier";
        }
        if (typedValue instanceof Reference && (r2 = (Reference)typedValue).hasReferenceElement()) {
            return "url";
        }
        if (typedValue instanceof Reference && (r = (Reference)typedValue).hasIdentifier()) {
            return "identifier";
        }
        return null;
    }

    private String getFhirType(Type typedValue) {
        Reference r;
        Reference r2;
        String type = typedValue.getClass().getAnnotation(DatatypeDef.class).name();
        if (typedValue instanceof Reference && (r2 = (Reference)typedValue).hasReferenceElement()) {
            return type + ".reference";
        }
        if (typedValue instanceof Reference && (r = (Reference)typedValue).hasIdentifier()) {
            return type + ".identifier";
        }
        return type;
    }

    private String getStringValue(Type typedValue) {
        Reference r;
        if (typedValue instanceof DecimalType) {
            DecimalType d = (DecimalType)typedValue;
            return d.hasValue() ? String.valueOf(d.getValue()) : null;
        }
        if (typedValue instanceof IntegerType) {
            IntegerType i = (IntegerType)typedValue;
            return i.hasValue() ? String.valueOf(i.getValue()) : null;
        }
        if (typedValue instanceof DateType) {
            DateType d = (DateType)typedValue;
            return d.hasValue() ? this.format((Date)d.getValue(), DATE_FORMAT) : null;
        }
        if (typedValue instanceof DateTimeType) {
            DateTimeType dt = (DateTimeType)typedValue;
            return dt.hasValue() ? this.format((Date)dt.getValue(), DATE_TIME_FORMAT) : null;
        }
        if (typedValue instanceof TimeType) {
            TimeType t = (TimeType)typedValue;
            return t.hasValue() ? (String)t.getValue() : null;
        }
        if (typedValue instanceof InstantType) {
            InstantType i = (InstantType)typedValue;
            return i.hasValue() ? this.format((Date)i.getValue(), DATE_TIME_FORMAT) : null;
        }
        if (typedValue instanceof StringType) {
            StringType s = (StringType)typedValue;
            return s.hasValue() ? (String)s.getValue() : null;
        }
        if (typedValue instanceof UriType) {
            UriType u = (UriType)typedValue;
            return u.hasValue() ? (String)u.getValue() : null;
        }
        if (typedValue instanceof Reference && (r = (Reference)typedValue).hasReferenceElement()) {
            return r.getReferenceElement().hasValue() ? r.getReferenceElement().getValue() : null;
        }
        return null;
    }

    private ElementSystemValue getSystemValueValue(Type typedValue) {
        Reference r;
        if (typedValue instanceof Coding) {
            Coding c = (Coding)typedValue;
            return ElementSystemValue.from(c);
        }
        if (typedValue instanceof Identifier) {
            Identifier i = (Identifier)typedValue;
            return ElementSystemValue.from(i);
        }
        if (typedValue instanceof Reference && (r = (Reference)typedValue).hasIdentifier()) {
            return ElementSystemValue.from(r.getIdentifier());
        }
        return null;
    }

    private Boolean getBooleanValue(Type typedValue) {
        if (typedValue instanceof BooleanType) {
            BooleanType b = (BooleanType)typedValue;
            return b.hasValue() ? (Boolean)b.getValue() : null;
        }
        return null;
    }

    private List<ExtensionItem> toExtensionItems(List<Extension> extensions) {
        ArrayList<ExtensionItem> items = new ArrayList<ExtensionItem>();
        extensions.forEach(e -> this.addExtensionItem(null, (Extension)e, (List<ExtensionItem>)items));
        return items;
    }

    private void addExtensionItem(String baseUrl, Extension extension, List<ExtensionItem> items) {
        Boolean booleanValue;
        String url = Stream.of(baseUrl, this.getUri(extension, Extension::hasUrlElement, Extension::getUrlElement)).filter(s -> s != null).collect(Collectors.joining(" | "));
        String type = extension.hasValue() ? this.getHtmlInputType(extension.getValue()) : null;
        String stringValue = extension.hasValue() ? this.getStringValue(extension.getValue()) : null;
        ElementSystemValue systemValueValue = extension.hasValue() ? this.getSystemValueValue(extension.getValue()) : null;
        Boolean bl = booleanValue = extension.hasValue() ? this.getBooleanValue(extension.getValue()) : null;
        if (stringValue != null || systemValueValue != null || booleanValue != null) {
            items.add(new ExtensionItem(UUID.randomUUID().toString(), type, url, stringValue, systemValueValue, booleanValue));
        }
        if (extension.hasExtension()) {
            extension.getExtension().forEach(e -> this.addExtensionItem(url, (Extension)e, items));
        }
    }

    private record Element(String process, String messageName, String businessKey, String correlationKey, ElementSystemValue requester, ElementSystemValue recipient, String authoredOn, List<InputItem> input, List<OutputItem> output) {
    }

    private record InputItem(String id, String type, String label, String labelTitle, String fhirType, String stringValue, ElementSystemValue systemValueValue, Boolean booleanValue) {
    }

    private record OutputItem(String id, String type, String label, String labelTitle, String stringValue, ElementSystemValue systemValueValue, Boolean booleanValue, List<ExtensionItem> extension) {
    }

    private record ExtensionItem(String id, String type, String url, String stringValue, ElementSystemValue systemValueValue, Boolean booleanValue) {
    }
}

