/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractResource;
import org.hl7.fhir.r4.model.Subscription;

public class ResourceSubscription
extends AbstractResource<Subscription> {
    public ResourceSubscription() {
        super(Subscription.class, AbstractResource.ActiveOrStatus.status(Subscription::hasStatusElement, Subscription::getStatusElement));
    }

    protected Element toElement(Subscription resource) {
        String reason = this.getString(resource, Subscription::hasReasonElement, Subscription::getReasonElement);
        String criteria = this.getString(resource, Subscription::hasCriteriaElement, Subscription::getCriteriaElement);
        String channelType = resource.hasChannel() && resource.getChannel().hasTypeElement() && resource.getChannel().getTypeElement().hasCode() ? resource.getChannel().getTypeElement().getCode() : "";
        String channelPayload = resource.hasChannel() && resource.getChannel().hasPayloadElement() && resource.getChannel().getPayloadElement().hasCode() ? resource.getChannel().getPayloadElement().getCode() : "";
        return new Element(reason, criteria, channelType, channelPayload);
    }

    private record Element(String reason, String criteria, String channelType, String channelPayload) {
    }
}

