/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import dev.dsf.fhir.adapter.AbstractResource;
import dev.dsf.fhir.adapter.ElementSystemValue;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceQuestionnaireResponse
extends AbstractResource<QuestionnaireResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceQuestionnaireResponse.class);
    private static final String CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_BUSINESS_KEY = "business-key";
    private static final String CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_USER_TASK_ID = "user-task-id";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    public ResourceQuestionnaireResponse() {
        super(QuestionnaireResponse.class, AbstractResource.ActiveOrStatus.status(QuestionnaireResponse::hasStatusElement, QuestionnaireResponse::getStatusElement));
    }

    @Override
    protected void doSetAdditionalVariables(BiConsumer<String, Object> variables, QuestionnaireResponse resource) {
        variables.accept("form", true);
    }

    protected Element toElement(QuestionnaireResponse resource) {
        String questionnaire = resource.hasQuestionnaireElement() && resource.getQuestionnaireElement().hasValue() ? ((String)resource.getQuestionnaireElement().getValue()).replace("|", " | ") : null;
        String businessKey = this.getStringValue(resource, CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_BUSINESS_KEY);
        String userTaskId = this.getStringValue(resource, CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_USER_TASK_ID);
        List<Item> item = resource.hasItem() ? resource.getItem().stream().map(this::toItem).toList() : null;
        return new Element(questionnaire, businessKey, userTaskId, item);
    }

    private String getStringValue(QuestionnaireResponse resource, String linkId) {
        return resource.hasItem() ? (String)resource.getItem().stream().filter(QuestionnaireResponse.QuestionnaireResponseItemComponent::hasLinkIdElement).filter(i -> i.getLinkIdElement().hasValue()).filter(i -> linkId.equals(i.getLinkIdElement().getValue())).filter(QuestionnaireResponse.QuestionnaireResponseItemComponent::hasAnswer).filter(i -> i.getAnswer().size() == 1).map(QuestionnaireResponse.QuestionnaireResponseItemComponent::getAnswer).flatMap(Collection::stream).filter(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent::hasValue).map(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent::getValue).filter(v -> v instanceof StringType).map(v -> (StringType)v).filter(s -> s.hasValue()).map(PrimitiveType::getValue).findFirst().orElse(null) : null;
    }

    private Item toItem(QuestionnaireResponse.QuestionnaireResponseItemComponent i) {
        String linkId;
        boolean show = i.hasLinkIdElement() && i.getLinkIdElement().hasValue() && !CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_BUSINESS_KEY.equals(i.getLinkIdElement().getValue()) && !CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_USER_TASK_ID.equals(i.getLinkIdElement().getValue());
        String text = i.hasTextElement() && i.getTextElement().hasValue() ? (String)i.getTextElement().getValue() : null;
        String string = linkId = i.hasLinkIdElement() && i.getLinkIdElement().hasValue() ? (String)i.getLinkIdElement().getValue() : null;
        if (i.hasAnswer() && i.getAnswer().size() == 1) {
            return this.toItem(show, linkId, text, i.getAnswerFirstRep().getValue());
        }
        return new Item(show, linkId, null, text, null, null, null, null);
    }

    private Item toItem(boolean show, String id, String label, Type typedValue) {
        String fhirType = typedValue.getClass().getAnnotation(DatatypeDef.class).name();
        if (typedValue instanceof BooleanType) {
            BooleanType b = (BooleanType)typedValue;
            return new Item(show, id, "boolean", label, fhirType, null, null, b.hasValue() ? (Boolean)b.getValue() : null);
        }
        if (typedValue instanceof DecimalType) {
            DecimalType d = (DecimalType)typedValue;
            return new Item(show, id, "number", label, fhirType, d.hasValue() ? String.valueOf(d.getValue()) : null, null, null);
        }
        if (typedValue instanceof IntegerType) {
            IntegerType i = (IntegerType)typedValue;
            return new Item(show, id, "number", label, fhirType, i.hasValue() ? String.valueOf(i.getValue()) : null, null, null);
        }
        if (typedValue instanceof DateType) {
            DateType d = (DateType)typedValue;
            return new Item(show, id, "date", label, fhirType, d.hasValue() ? this.format((Date)d.getValue(), DATE_FORMAT) : null, null, null);
        }
        if (typedValue instanceof DateTimeType) {
            DateTimeType dt = (DateTimeType)typedValue;
            return new Item(show, id, "datetime-local", label, fhirType, dt.hasValue() ? this.format((Date)dt.getValue(), DATE_TIME_FORMAT) : null, null, null);
        }
        if (typedValue instanceof TimeType) {
            TimeType t = (TimeType)typedValue;
            return new Item(show, id, "time", label, fhirType, t.hasValue() ? (String)t.getValue() : null, null, null);
        }
        if (typedValue instanceof StringType) {
            StringType s = (StringType)typedValue;
            return new Item(show, id, "text", label, fhirType, s.hasValue() ? (String)s.getValue() : null, null, null);
        }
        if (typedValue instanceof UriType) {
            UriType u = (UriType)typedValue;
            return new Item(show, id, "url", label, fhirType, u.hasValue() ? (String)u.getValue() : null, null, null);
        }
        if (typedValue instanceof Coding) {
            Coding c = (Coding)typedValue;
            return new Item(show, id, "coding", label, fhirType, null, ElementSystemValue.from(c), null);
        }
        if (typedValue instanceof Reference) {
            Reference r = (Reference)typedValue;
            if (r.hasReferenceElement()) {
                return new Item(show, id, "url", label, fhirType + ".reference", r.getReferenceElement().hasValue() ? r.getReferenceElement().getValue() : null, null, null);
            }
            if (r.hasIdentifier()) {
                return new Item(show, id, "identifier", label, fhirType + ".identifier", null, ElementSystemValue.from(r.getIdentifier()), null);
            }
        }
        logger.warn("Element of type {}, not supported", (Object)fhirType);
        return null;
    }

    private record Element(String questionnaire, String businessKey, String userTaskId, List<Item> item) {
    }

    private record Item(boolean show, String id, String type, String label, String fhirType, String stringValue, ElementSystemValue systemValueValue, Boolean booleanValue) {
    }
}

