/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractMetdataResource;
import java.util.List;
import org.hl7.fhir.r4.model.Questionnaire;

public class ResourceQuestionnaire
extends AbstractMetdataResource<Questionnaire> {
    public ResourceQuestionnaire() {
        super(Questionnaire.class);
    }

    protected Element toElement(Questionnaire resource) {
        String description = this.getString(resource, Questionnaire::hasDescriptionElement, Questionnaire::getDescriptionElement);
        List<Item> item = resource.hasItem() ? resource.getItem().stream().map(i -> {
            String linkId = i.hasLinkIdElement() && i.getLinkIdElement().hasValue() ? (String)i.getLinkIdElement().getValue() : null;
            String text = i.hasTextElement() && i.getTextElement().hasValue() ? (String)i.getTextElement().getValue() : null;
            String type = i.hasTypeElement() && i.getTypeElement().hasCode() ? i.getTypeElement().getCode() : null;
            return new Item(linkId, text, type);
        }).toList() : null;
        return new Element(description, item);
    }

    private record Element(String description, List<Item> item) {
    }

    private record Item(String linkId, String text, String type) {
    }
}

