/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractResource;
import dev.dsf.fhir.adapter.ElementId;
import dev.dsf.fhir.adapter.ElementSystemValue;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.OrganizationAffiliation;

public class ResourceOrganizationAffiliation
extends AbstractResource<OrganizationAffiliation> {
    public ResourceOrganizationAffiliation() {
        super(OrganizationAffiliation.class, AbstractResource.ActiveOrStatus.active(OrganizationAffiliation::hasActiveElement, OrganizationAffiliation::getActiveElement));
    }

    protected Element toElement(OrganizationAffiliation resource) {
        List<ElementSystemValue> identifier = this.getIdentifiers(resource, OrganizationAffiliation::hasIdentifier, OrganizationAffiliation::getIdentifier);
        ElementId organization = ElementId.from(resource, OrganizationAffiliation::hasOrganization, OrganizationAffiliation::getOrganization);
        ElementId participatingOrganization = ElementId.from(resource, OrganizationAffiliation::hasParticipatingOrganization, OrganizationAffiliation::getParticipatingOrganization);
        List<ElementSystemValue> code = resource.hasCode() ? resource.getCode().stream().map(CodeableConcept::getCoding).flatMap(Collection::stream).map(ElementSystemValue::from).toList() : null;
        ElementId endpoint = ElementId.from(resource, OrganizationAffiliation::hasEndpoint, OrganizationAffiliation::getEndpointFirstRep);
        return new Element(this.nullIfEmpty(identifier), organization, participatingOrganization, this.nullIfEmpty(code), endpoint);
    }

    private record Element(List<ElementSystemValue> identifier, ElementId organization, ElementId participatingOrganization, List<ElementSystemValue> code, ElementId endpoint) {
    }
}

