/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractResource;
import dev.dsf.fhir.adapter.ElementId;
import dev.dsf.fhir.adapter.ElementSystemValue;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.PrimitiveType;

public class ResourceOrganization
extends AbstractResource<Organization> {
    public ResourceOrganization() {
        super(Organization.class, AbstractResource.ActiveOrStatus.active(Organization::hasActiveElement, Organization::getActiveElement));
    }

    protected Element toElement(Organization resource) {
        List<ElementSystemValue> identifier = this.getIdentifiers(resource, Organization::hasIdentifier, Organization::getIdentifier);
        List<ElementSystemValue> type = resource.hasType() ? resource.getType().stream().map(CodeableConcept::getCoding).flatMap(Collection::stream).map(ElementSystemValue::from).toList() : null;
        String name = this.getString(resource, Organization::hasNameElement, Organization::getNameElement);
        List<String> alias = resource.hasAlias() ? resource.getAlias().stream().filter(PrimitiveType::hasValue).map(PrimitiveType::getValue).toList() : null;
        List<ElementSystemValue> telecom = resource.hasTelecom() ? resource.getTelecom().stream().filter(ContactPoint::hasSystemElement).filter(ContactPoint::hasValueElement).filter(p -> p.getSystemElement().hasValue()).filter(p -> p.getValueElement().hasValue()).map(p -> {
            String system = ((ContactPoint.ContactPointSystem)p.getSystemElement().getValue()).getDisplay();
            String value = (String)p.getValueElement().getValue();
            return ElementSystemValue.from(system, value);
        }).toList() : null;
        List<HtmlAddressElement> address = resource.hasAddress() ? resource.getAddress().stream().map(HtmlAddressElement::from).filter(a -> a != null).toList() : null;
        List<ElementId> endpoint = ElementId.fromList(resource, Organization::hasEndpoint, Organization::getEndpoint);
        return new Element(this.nullIfEmpty(identifier), this.nullIfEmpty(type), name, this.nullIfEmpty(alias), this.nullIfEmpty(telecom), this.nullIfEmpty(address), endpoint);
    }

    private record Element(List<ElementSystemValue> identifier, List<ElementSystemValue> type, String name, List<String> alias, List<ElementSystemValue> telecom, List<HtmlAddressElement> address, List<ElementId> endpoint) {
    }

    private record HtmlAddressElement(List<String> line, String postalCodeAndCity, String country) {
        static HtmlAddressElement from(Address address) {
            if (address == null) {
                return null;
            }
            List<String> line = address.hasLine() ? address.getLine().stream().filter(PrimitiveType::hasValue).map(PrimitiveType::getValue).toList() : null;
            line = line != null && line.isEmpty() ? null : line;
            String postalCode = address.hasPostalCodeElement() && address.getPostalCodeElement().hasValue() ? (String)address.getPostalCodeElement().getValue() : null;
            String city = address.hasCityElement() && address.getCityElement().hasValue() ? (String)address.getCityElement().getValue() : null;
            String country = address.hasCountryElement() && address.getCountryElement().hasValue() ? (String)address.getCountryElement().getValue() : null;
            return line != null || postalCode != null || city != null || country != null ? new HtmlAddressElement(line, Stream.of(postalCode, city).filter(s -> s != null).collect(Collectors.joining(" ")), country) : null;
        }
    }
}

