/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractResource;
import dev.dsf.fhir.adapter.ElementId;
import dev.dsf.fhir.adapter.ElementSystemValue;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.PrimitiveType;

public class ResourceMeasureReport
extends AbstractResource<MeasureReport> {
    private static final String MEASURE_URL_PATTERN_STRING = "((http|https):\\/\\/([A-Za-z0-9\\-\\\\\\.\\:\\%\\$]*\\/)+)?Measure\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?";
    private static final Pattern MEASURE_URL_PATTERN = Pattern.compile("((http|https):\\/\\/([A-Za-z0-9\\-\\\\\\.\\:\\%\\$]*\\/)+)?Measure\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?");
    private final String serverBaseUrl;

    public ResourceMeasureReport(String serverBaseUrl) {
        super(MeasureReport.class, AbstractResource.ActiveOrStatus.status(MeasureReport::hasStatusElement, MeasureReport::getStatusElement));
        this.serverBaseUrl = serverBaseUrl;
    }

    protected Element toElement(MeasureReport resource) {
        List<ElementSystemValue> identifier = this.getIdentifiers(resource, MeasureReport::hasIdentifier, MeasureReport::getIdentifier);
        String type = this.getEnumeration(resource, MeasureReport::hasTypeElement, MeasureReport::getTypeElement);
        ElementId measure = this.getMeasure(resource);
        String date = this.getDateTime(resource, MeasureReport::hasDateElement, MeasureReport::getDateElement);
        String groupPopulationCount = this.getGroupPopulationCount(resource);
        return new Element(identifier, type, measure, date, groupPopulationCount);
    }

    private ElementId getMeasure(MeasureReport resource) {
        if (!resource.hasMeasureElement() || !resource.getMeasureElement().hasValue()) {
            return null;
        }
        String measureCanonical = (String)resource.getMeasureElement().getValue();
        if (measureCanonical != null && MEASURE_URL_PATTERN.matcher(measureCanonical).matches()) {
            IdType measureId = new IdType(measureCanonical);
            if (!measureId.hasBaseUrl() || this.serverBaseUrl.equals(measureId.getBaseUrl())) {
                return ElementId.from((IIdType)measureId);
            }
            return ElementId.from(measureId.getValue(), "Measure", measureId.getValue());
        }
        return null;
    }

    private String getGroupPopulationCount(MeasureReport resource) {
        if (!resource.hasGroup()) {
            return null;
        }
        List<String> values = resource.getGroup().stream().filter(MeasureReport.MeasureReportGroupComponent::hasPopulation).map(MeasureReport.MeasureReportGroupComponent::getPopulation).flatMap(Collection::stream).filter(MeasureReport.MeasureReportGroupPopulationComponent::hasCode).filter(MeasureReport.MeasureReportGroupPopulationComponent::hasCountElement).filter(g -> g.getCode().hasCoding() && g.getCode().getCoding().stream().filter(Coding::hasSystem).filter(Coding::hasCode).filter(c -> "http://terminology.hl7.org/CodeSystem/measure-population".equals(c.getSystem()) && "initial-population".equals(c.getCode())).count() >= 1L).map(MeasureReport.MeasureReportGroupPopulationComponent::getCountElement).filter(PrimitiveType::hasValue).map(PrimitiveType::getValue).map(String::valueOf).toList();
        if (values.size() != 1) {
            return null;
        }
        return values.get(0);
    }

    private record Element(List<ElementSystemValue> identifier, String type, ElementId measure, String date, String groupPopulationCount) {
    }
}

