/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractMetdataResource;
import dev.dsf.fhir.adapter.ElementSystemValue;
import java.util.List;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.PrimitiveType;

public class ResourceMeasure
extends AbstractMetdataResource<Measure> {
    public ResourceMeasure() {
        super(Measure.class);
    }

    protected Element toElement(Measure resource) {
        String subtitle = this.getString(resource, Measure::hasSubtitleElement, Measure::getSubtitleElement);
        String description = this.getString(resource, Measure::hasDescriptionElement, Measure::getDescriptionElement);
        List<String> library = resource.hasLibrary() ? resource.getLibrary().stream().filter(PrimitiveType::hasValue).map(PrimitiveType::getValue).toList() : null;
        List<ElementSystemValue> scoring = resource.hasScoring() ? resource.getScoring().getCoding().stream().map(ElementSystemValue::from).toList() : null;
        return new Element(subtitle, description, library, scoring);
    }

    private record Element(String subtitle, String description, List<String> library, List<ElementSystemValue> scoring) {
    }
}

