/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractMetdataResource;
import java.util.List;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Library;

public class ResourceLibrary
extends AbstractMetdataResource<Library> {
    public ResourceLibrary() {
        super(Library.class);
    }

    protected Element toElement(Library resource) {
        String subtitle = this.getString(resource, Library::hasSubtitleElement, Library::getSubtitleElement);
        String description = this.getString(resource, Library::hasDescriptionElement, Library::getDescriptionElement);
        List<String> type = resource.hasType() && resource.getType().hasCoding() ? resource.getType().getCoding().stream().filter(Coding::hasSystemElement).filter(Coding::hasCodeElement).filter(c -> c.getSystemElement().hasValue()).filter(c -> c.getCodeElement().hasValue()).map(c -> (String)c.getSystemElement().getValue() + " | " + (String)c.getCodeElement().getValue()).toList() : null;
        return new Element(subtitle, description, type);
    }

    private record Element(String subtitle, String description, List<String> type) {
    }
}

