/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractResource;
import dev.dsf.fhir.adapter.ElementId;
import dev.dsf.fhir.adapter.ElementSystemValue;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.PrimitiveType;

public class ResourceEndpoint
extends AbstractResource<Endpoint> {
    public ResourceEndpoint() {
        super(Endpoint.class, AbstractResource.ActiveOrStatus.status(Endpoint::hasStatusElement, Endpoint::getStatusElement));
    }

    protected Element toElement(Endpoint resource) {
        List<ElementSystemValue> identifier = this.getIdentifiers(resource, Endpoint::hasIdentifier, Endpoint::getIdentifier);
        ElementSystemValue connectionType = resource.hasConnectionType() ? ElementSystemValue.from(resource.getConnectionType()) : null;
        String name = this.getString(resource, Endpoint::hasNameElement, Endpoint::getNameElement);
        ElementId managingOrganization = ElementId.from(resource, Endpoint::hasManagingOrganization, Endpoint::getManagingOrganization);
        List<ElementSystemValue> payloadType = resource.hasPayloadType() ? resource.getPayloadType().stream().map(CodeableConcept::getCoding).flatMap(Collection::stream).map(ElementSystemValue::from).toList() : null;
        List<String> payloadMimeType = resource.hasPayloadMimeType() ? resource.getPayloadMimeType().stream().filter(PrimitiveType::hasValue).map(PrimitiveType::getValue).toList() : null;
        String address = this.getUrl(resource, Endpoint::hasAddressElement, Endpoint::getAddressElement);
        return new Element(this.nullIfEmpty(identifier), connectionType, name, managingOrganization, this.nullIfEmpty(payloadType), this.nullIfEmpty(payloadMimeType), address);
    }

    private record Element(List<ElementSystemValue> identifier, ElementSystemValue connectionType, String name, ElementId managingOrganization, List<ElementSystemValue> payloadType, List<String> payloadMimeType, String address) {
    }
}

