/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractMetdataResource;
import java.util.List;
import org.hl7.fhir.r4.model.CodeSystem;

public class ResourceCodeSystem
extends AbstractMetdataResource<CodeSystem> {
    public ResourceCodeSystem() {
        super(CodeSystem.class);
    }

    protected Element toElement(CodeSystem resource) {
        String description = this.getString(resource, CodeSystem::hasDescriptionElement, CodeSystem::getDescriptionElement);
        Boolean caseSensitive = this.getBoolean(resource, CodeSystem::hasCaseSensitiveElement, CodeSystem::getCaseSensitiveElement);
        String hierarchyMeaning = this.getEnumeration(resource, CodeSystem::hasHierarchyMeaningElement, CodeSystem::getHierarchyMeaningElement);
        Boolean versionNeeded = this.getBoolean(resource, CodeSystem::hasVersionNeededElement, CodeSystem::getVersionNeededElement);
        String content = this.getEnumeration(resource, CodeSystem::hasContentElement, CodeSystem::getContentElement);
        Integer count = this.getInteger(resource, CodeSystem::hasCountElement, CodeSystem::getCountElement);
        List<Concept> concept = resource.hasConcept() ? resource.getConcept().stream().map(i -> {
            String code = i.hasCodeElement() && i.getCodeElement().hasValue() ? (String)i.getCodeElement().getValue() : null;
            String display = i.hasDisplayElement() && i.getDisplayElement().hasValue() ? (String)i.getDisplayElement().getValue() : null;
            String definition = i.hasDefinitionElement() && i.getDefinitionElement().hasValue() ? (String)i.getDefinitionElement().getValue() : null;
            return new Concept(code, display, definition);
        }).toList() : null;
        return new Element(description, caseSensitive, hierarchyMeaning, versionNeeded, content, count, concept);
    }

    private record Element(String description, Boolean caseSensitive, String hierarchyMeaning, Boolean versionNeeded, String content, Integer count, List<Concept> concept) {
    }

    private record Concept(String code, String display, String definition) {
    }
}

