/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractMetdataResource;
import dev.dsf.fhir.adapter.ElementSystemValue;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class ResourceActivityDefinition
extends AbstractMetdataResource<ActivityDefinition> {
    private static final List<String> PROCESS_AUTHORIZATION_CODES = List.of("LOCAL_ORGANIZATION", "LOCAL_ORGANIZATION_PRACTITIONER", "REMOTE_ORGANIZATION", "LOCAL_ROLE", "LOCAL_ROLE_PRACTITIONER", "REMOTE_ROLE", "LOCAL_ALL", "LOCAL_ALL_PRACTITIONER", "REMOTE_ALL");

    public ResourceActivityDefinition() {
        super(ActivityDefinition.class);
    }

    protected Element toElement(ActivityDefinition resource) {
        String subtitle = this.getString(resource, ActivityDefinition::hasSubtitleElement, ActivityDefinition::getSubtitleElement);
        String description = this.getString(resource, ActivityDefinition::hasDescriptionElement, ActivityDefinition::getDescriptionElement);
        List<Authorization> authorizations = resource.getExtensionsByUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization").stream().map(this::toAuthorization).toList();
        return new Element(subtitle, description, authorizations);
    }

    private Authorization toAuthorization(Extension authorization) {
        String messageName = this.getValue(authorization, "message-name", StringType.class).map(PrimitiveType::getValue).orElse(null);
        String taskProfile = this.getValue(authorization, "task-profile", CanonicalType.class).map(PrimitiveType::getValue).filter(s -> s != null && !s.isBlank()).map(s -> s.replace("|", " | ")).orElse(null);
        List<AuthorizationEntry> requester = this.getValues(authorization, "requester", Coding.class).map(this::toAuthorizationEntry).filter(a -> a != null).toList();
        List<AuthorizationEntry> recipient = this.getValues(authorization, "recipient", Coding.class).map(this::toAuthorizationEntry).filter(a -> a != null).toList();
        return new Authorization(messageName, taskProfile, requester, recipient);
    }

    private AuthorizationEntry toAuthorizationEntry(Coding entry) {
        String type;
        String string = type = entry.hasSystemElement() && entry.getSystemElement().hasValue() && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(entry.getSystemElement().getValue()) && entry.hasCodeElement() && entry.getCodeElement().hasValue() && PROCESS_AUTHORIZATION_CODES.contains(entry.getCodeElement().getValue()) ? (String)entry.getCodeElement().getValue() : null;
        if (type == null) {
            return null;
        }
        ElementSystemValue organization = null;
        ElementSystemValue practitionerRole = null;
        ElementSystemValue organizationRole = null;
        ElementSystemValue parentOrganization = null;
        switch (type) {
            case "LOCAL_ALL_PRACTITIONER": {
                Type type2;
                List exts = entry.getExtensionsByUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-practitioner");
                if (exts == null || exts.size() != 1) {
                    return null;
                }
                Extension ext = (Extension)exts.get(0);
                if (ext.hasValue() && (type2 = ext.getValue()) instanceof Coding) {
                    Coding c = (Coding)type2;
                    practitionerRole = ElementSystemValue.from(c);
                    break;
                }
                return null;
            }
            case "LOCAL_ORGANIZATION": 
            case "REMOTE_ORGANIZATION": {
                Type type3;
                List exts = entry.getExtensionsByUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization");
                if (exts == null || exts.size() != 1) {
                    return null;
                }
                Extension ext = (Extension)exts.get(0);
                if (ext.hasValue() && (type3 = ext.getValue()) instanceof Identifier) {
                    Identifier i = (Identifier)type3;
                    organization = ElementSystemValue.from(i);
                    break;
                }
                return null;
            }
            case "LOCAL_ORGANIZATION_PRACTITIONER": {
                List exts = entry.getExtensionsByUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization-practitioner");
                if (exts == null || exts.size() != 1) {
                    return null;
                }
                Optional<ElementSystemValue> o = this.getValue((Extension)exts.get(0), "organization", Identifier.class).map(ElementSystemValue::from);
                Optional<ElementSystemValue> pR = this.getValue((Extension)exts.get(0), "practitioner-role", Coding.class).map(ElementSystemValue::from);
                if (o.isPresent() && pR.isPresent()) {
                    organization = o.get();
                    practitionerRole = pR.get();
                    break;
                }
                return null;
            }
            case "LOCAL_ROLE": 
            case "REMOTE_ROLE": {
                List exts = entry.getExtensionsByUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-parent-organization-role");
                if (exts == null || exts.size() != 1) {
                    return null;
                }
                Optional<ElementSystemValue> pO = this.getValue((Extension)exts.get(0), "parent-organization", Identifier.class).map(ElementSystemValue::from);
                Optional<ElementSystemValue> oR = this.getValue((Extension)exts.get(0), "organization-role", Coding.class).map(ElementSystemValue::from);
                if (pO.isPresent() && oR.isPresent()) {
                    parentOrganization = pO.get();
                    organizationRole = oR.get();
                    break;
                }
                return null;
            }
            case "LOCAL_ROLE_PRACTITIONER": {
                List exts = entry.getExtensionsByUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-parent-organization-role-practitioner");
                if (exts == null || exts.size() != 1) {
                    return null;
                }
                Optional<ElementSystemValue> pO = this.getValue((Extension)exts.get(0), "parent-organization", Identifier.class).map(ElementSystemValue::from);
                Optional<ElementSystemValue> oR = this.getValue((Extension)exts.get(0), "organization-role", Coding.class).map(ElementSystemValue::from);
                Optional<ElementSystemValue> pR = this.getValue((Extension)exts.get(0), "practitioner-role", Coding.class).map(ElementSystemValue::from);
                if (pO.isPresent() && oR.isPresent() && pR.isPresent()) {
                    parentOrganization = pO.get();
                    organizationRole = oR.get();
                    practitionerRole = pR.get();
                    break;
                }
                return null;
            }
        }
        return new AuthorizationEntry(type, organization, practitionerRole, organizationRole, parentOrganization);
    }

    private <T extends Type> Optional<T> getValue(Extension ex, String url, Class<T> type) {
        return this.getValues(ex, url, type).findFirst();
    }

    private <T extends Type> Stream<T> getValues(Extension ex, String url, Class<T> type) {
        return ex.getExtension().stream().filter(Extension::hasUrlElement).filter(e -> e.getUrlElement().hasValue()).filter(e -> url.equals(e.getUrlElement().getValue())).filter(Extension::hasValue).map(Extension::getValue).filter(type::isInstance).map(type::cast);
    }

    private record Element(String subtitle, String description, List<Authorization> authorizations) {
    }

    private record Authorization(String messageName, String taskProfile, List<AuthorizationEntry> requester, List<AuthorizationEntry> recipient) {
    }

    private record AuthorizationEntry(String type, ElementSystemValue organization, ElementSystemValue practitionerRole, ElementSystemValue organizationRole, ElementSystemValue parentOrganization) {
    }
}

