/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.BaseReference;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;

public final class ElementId {
    private final String href;
    private final String resourceType;
    private final String value;

    public static <R extends Resource> List<ElementId> fromList(R resource, Predicate<R> hasReferences, Function<R, List<Reference>> getReferences) {
        List<Reference> references = resource != null && hasReferences.test(resource) ? getReferences.apply(resource) : null;
        return references != null && !references.isEmpty() ? references.stream().filter(Reference::hasReferenceElement).map(BaseReference::getReferenceElement).map(ElementId::from).toList() : null;
    }

    public static <R extends Resource> ElementId from(R resource, Predicate<R> hasReference, Function<R, Reference> getReference) {
        Reference ref = resource != null && hasReference.test(resource) ? getReference.apply(resource) : null;
        IIdType id = ref != null && ref.hasReferenceElement() ? ref.getReferenceElement() : null;
        return id != null ? ElementId.from(id) : null;
    }

    public static ElementId from(Resource resource) {
        return resource != null && resource.hasIdElement() ? ElementId.from((IIdType)resource.getIdElement()) : null;
    }

    public static ElementId from(IIdType id) {
        Objects.requireNonNull(id, "id");
        String href = id.toVersionless().getValue();
        String resourceType = id.getResourceType();
        String value = id.getIdPart();
        return new ElementId(href, resourceType, value);
    }

    public static ElementId from(String href, String resourceType, String value) {
        Objects.requireNonNull(href, "href");
        Objects.requireNonNull(resourceType, "resourceType");
        Objects.requireNonNull(value, "value");
        return new ElementId(href, resourceType, value);
    }

    private ElementId(String href, String resourceType, String value) {
        this.href = href;
        this.resourceType = resourceType;
        this.value = value;
    }

    public String getHref() {
        return this.href;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getValue() {
        return this.value;
    }
}

