/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import dev.dsf.fhir.adapter.AbstractThymeleafContext;
import dev.dsf.fhir.adapter.ElementId;
import jakarta.ws.rs.core.MultivaluedMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.glassfish.jersey.uri.UriComponent;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;

abstract class AbstractSearchSet<MR extends Resource>
extends AbstractThymeleafContext<Bundle> {
    protected static final String INSTANTIATES_CANONICAL_PATTERN_STRING = "(?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$";
    protected static final Pattern INSTANTIATES_CANONICAL_PATTERN = Pattern.compile("(?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$");
    protected static final String CODE_SYSTEM_BPMN_MESSAGE = "http://dsf.dev/fhir/CodeSystem/bpmn-message";
    protected static final String CODE_SYSTEM_BPMN_MESSAGE_MESSAGE_NAME = "message-name";
    protected static final String CODE_SYSTEM_BPMN_MESSAGE_BUSINESS_KEY = "business-key";
    protected static final String CODE_SYSTEM_ORGANIZATION_ROLE = "http://dsf.dev/fhir/CodeSystem/organization-role";
    protected static final String EXTENSION_PROCESS_AUTHORIZATION = "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization";
    protected static final String EXTENSION_PROCESS_AUTHORIZATION_MESSAGE_NAME = "message-name";
    protected static final String NAMING_SYSTEM_ENDPOINT_IDENTIFIER = "http://dsf.dev/sid/endpoint-identifier";
    protected static final String NAMING_SYSTEM_ORGANIZATION_IDENTIFIER = "http://dsf.dev/sid/organization-identifier";
    protected static final String NAMING_SYSTEM_TASK_IDENTIFIER = "http://dsf.dev/sid/task-identifier";
    private final int defaultPageCount;
    private final Class<MR> matchResourceType;
    private final String htmlRowFragment;

    protected AbstractSearchSet(int defaultPageCount, Class<MR> matchResourceType) {
        this(defaultPageCount, matchResourceType, "searchset" + matchResourceType.getAnnotation(ResourceDef.class).name());
    }

    protected AbstractSearchSet(int defaultPageCount, Class<MR> matchResourceType, String htmlRowFragment) {
        super(Bundle.class, "searchset");
        this.defaultPageCount = defaultPageCount;
        this.matchResourceType = matchResourceType;
        this.htmlRowFragment = htmlRowFragment;
    }

    @Override
    public boolean isResourceSupported(String requestPathLastElement) {
        return this.matchResourceType.getAnnotation(ResourceDef.class).name().equals(requestPathLastElement);
    }

    @Override
    protected void doSetVariables(BiConsumer<String, Object> variables, Bundle resource) {
        List<Resource> matchResources = resource.getEntry().stream().filter(Bundle.BundleEntryComponent::hasSearch).filter(e -> Bundle.SearchEntryMode.MATCH.equals((Object)e.getSearch().getMode())).filter(Bundle.BundleEntryComponent::hasResource).map(Bundle.BundleEntryComponent::getResource).filter(this.matchResourceType::isInstance).map(this.matchResourceType::cast).toList();
        String first = resource.getLink().stream().filter(l -> "first".equals(l.getRelation())).findFirst().map(Bundle.BundleLinkComponent::getUrl).orElse(null);
        String previous = resource.getLink().stream().filter(l -> "previous".equals(l.getRelation())).findFirst().map(Bundle.BundleLinkComponent::getUrl).orElse(null);
        String next = resource.getLink().stream().filter(l -> "next".equals(l.getRelation())).findFirst().map(Bundle.BundleLinkComponent::getUrl).orElse(null);
        String last = resource.getLink().stream().filter(l -> "last".equals(l.getRelation())).findFirst().map(Bundle.BundleLinkComponent::getUrl).orElse(null);
        String self = resource.getLink().stream().filter(l -> "self".equals(l.getRelation())).findFirst().map(Bundle.BundleLinkComponent::getUrl).orElse(null);
        MultivaluedMap params = UriComponent.decodeQuery((URI)this.toUri(self), (boolean)false);
        int currentPage = this.getPage((MultivaluedMap<String, String>)params);
        int count = this.getCount((MultivaluedMap<String, String>)params, this.defaultPageCount);
        int maxPages = count <= 0 ? 0 : (int)Math.ceil((double)resource.getTotal() / (double)count);
        int offset = Math.multiplyExact(currentPage - 1, count);
        int firstResource = count == 0 ? 0 : (0x7FFFFFFE < offset ? 0 : offset + 1);
        int lastResource = Integer.MAX_VALUE - matchResources.size() < offset ? 0 : offset + matchResources.size();
        long includeResources = resource.getEntry().stream().filter(e -> e.hasResource() && e.hasSearch() && Bundle.SearchEntryMode.INCLUDE.equals((Object)e.getSearch().getMode())).count();
        List<String> diagnostics = resource.getEntry().stream().filter(Bundle.BundleEntryComponent::hasResource).map(Bundle.BundleEntryComponent::getResource).filter(r -> r instanceof OperationOutcome).map(r -> (OperationOutcome)r).map(OperationOutcome::getIssue).flatMap(Collection::stream).filter(OperationOutcome.OperationOutcomeIssueComponent::hasSeverity).filter(OperationOutcome.OperationOutcomeIssueComponent::hasDiagnostics).map(i -> i.getSeverity().getDisplay() + ": " + i.getDiagnostics()).toList();
        List<Object> elements = matchResources.stream().map(r -> this.toRow(ElementId.from(r), r)).toList();
        variables.accept("searchset", new SearchSetData(this.htmlRowFragment, first, next, previous, last, currentPage, maxPages, firstResource, lastResource, resource.getTotal(), includeResources, diagnostics, elements));
    }

    private URI toUri(String self) {
        try {
            return new URI(self);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private int getPage(MultivaluedMap<String, String> params) {
        String p = (String)params.getFirst((Object)"_page");
        if (p != null && !p.isBlank() && p.matches("[-+]{0,1}[0-9]+")) {
            try {
                return Integer.parseInt(p);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    private int getCount(MultivaluedMap<String, String> params, int defaultPageCount) {
        String p = (String)params.getFirst((Object)"_count");
        if (p != null && !p.isBlank() && p.matches("[-+]{0,1}[0-9]+")) {
            try {
                return Integer.parseInt(p);
            }
            catch (NumberFormatException e) {
                return defaultPageCount;
            }
        }
        return defaultPageCount;
    }

    protected final <D extends DomainResource> String getIdentifierValues(D resource, Function<D, Boolean> hasIdentifier, Function<D, List<Identifier>> getIdentifier, String identifierSystem) {
        if (!hasIdentifier.apply(resource).booleanValue()) {
            return "";
        }
        List<String> filteredIdentifiers = getIdentifier.apply(resource).stream().filter(i -> identifierSystem.equals(i.getSystem())).filter(Identifier::hasValue).map(Identifier::getValue).toList();
        if (filteredIdentifiers.isEmpty()) {
            return "";
        }
        return filteredIdentifiers.get(0) + (filteredIdentifiers.size() > 1 ? ", ..." : "");
    }

    protected final String getResourceType(IIdType id) {
        return id != null ? id.getResourceType() : "";
    }

    protected final Predicate<Task.ParameterComponent> isStringParam(String system, String code) {
        return p -> p.hasType() && p.getType().hasCoding() && p.getType().getCoding().stream().anyMatch(c -> system.equals(c.getSystem()) && code.equals(c.getCode())) && p.hasValue() && p.getValue() instanceof StringType;
    }

    protected abstract Object toRow(ElementId var1, MR var2);

    private record SearchSetData(String htmlRowFragment, String first, String next, String previous, String last, int currentPage, int maxPages, int firstResource, int lastResource, int totalResources, long includeResources, List<String> diagnostics, List<Object> elements) {
    }
}

