/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import dev.dsf.fhir.adapter.AbstractThymeleafContext;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Resource;

abstract class AbstractResource<R extends Resource>
extends AbstractThymeleafContext<R> {
    private final String htmlResourceFragment;
    private final ActiveOrStatus<R> activeOrStatus;

    protected AbstractResource(Class<R> resourceType, ActiveOrStatus<R> activeOrStatus) {
        this(resourceType, activeOrStatus, "resource" + resourceType.getAnnotation(ResourceDef.class).name());
    }

    protected AbstractResource(Class<R> resourceType, ActiveOrStatus<R> activeOrStatus, String htmlResourceFragment) {
        super(resourceType, "resource");
        this.activeOrStatus = activeOrStatus;
        this.htmlResourceFragment = htmlResourceFragment;
    }

    @Override
    public boolean isResourceSupported(String requestPathLastElement) {
        return true;
    }

    @Override
    protected final void doSetVariables(BiConsumer<String, Object> variables, R resource) {
        String type = this.getResourceType().getAnnotation(ResourceDef.class).name();
        String id = resource.hasIdElement() ? resource.getIdElement().getIdPart() : "";
        String version = resource.hasIdElement() ? resource.getIdElement().getVersionIdPart() : "";
        String lastUpdated = this.formatLastUpdated((Resource)resource);
        String profiles = resource.hasMeta() && resource.getMeta().hasProfile() ? resource.getMeta().getProfile().stream().filter(PrimitiveType::hasValue).map(PrimitiveType::getValue).map(s -> s.replace("|", " | ")).collect(Collectors.joining(", ")) : null;
        Boolean active = this.activeOrStatus.getActive(resource);
        String status = this.activeOrStatus.getStatus(resource);
        variables.accept("htmlResourceFragment", this.htmlResourceFragment);
        variables.accept("resource", new ResourceData(type, id, version, lastUpdated, profiles, active, status));
        String resourceTypeName = this.getResourceType().getAnnotation(ResourceDef.class).name();
        variables.accept(resourceTypeName.substring(0, 1).toLowerCase() + resourceTypeName.substring(1), this.toElement(resource));
        this.doSetAdditionalVariables(variables, resource);
    }

    protected abstract Object toElement(R var1);

    protected void doSetAdditionalVariables(BiConsumer<String, Object> variables, R resource) {
    }

    static class ActiveOrStatus<R extends Resource> {
        private final Predicate<R> hasActive;
        private final Function<R, BooleanType> getActive;
        private final Predicate<R> hasStatus;
        private final Function<R, Enumeration<?>> getStatus;

        static <R extends Resource> ActiveOrStatus<R> active(Predicate<R> hasActive, Function<R, BooleanType> getActive) {
            return new ActiveOrStatus<R>(Objects.requireNonNull(hasActive, "hasActive"), Objects.requireNonNull(getActive, "getActive"), null, null);
        }

        static <R extends Resource> ActiveOrStatus<R> status(Predicate<R> hasStatus, Function<R, Enumeration<?>> getStatus) {
            return new ActiveOrStatus<R>(null, null, Objects.requireNonNull(hasStatus, "hasStatus"), Objects.requireNonNull(getStatus, "getStatus"));
        }

        ActiveOrStatus(Predicate<R> hasActive, Function<R, BooleanType> getActive, Predicate<R> hasStatus, Function<R, Enumeration<?>> getStatus) {
            this.hasActive = hasActive;
            this.getActive = getActive;
            this.hasStatus = hasStatus;
            this.getStatus = getStatus;
        }

        Boolean getActive(R resource) {
            return this.hasActive != null && this.getActive != null && this.hasActive.test(resource) && this.getActive.apply(resource).hasValue() ? (Boolean)this.getActive.apply(resource).getValue() : null;
        }

        String getStatus(R resource) {
            return this.hasStatus != null && this.getStatus != null && this.hasStatus.test(resource) && this.getStatus.apply(resource).hasCode() ? this.getStatus.apply(resource).getCode() : null;
        }
    }

    private record ResourceData(String type, String id, String version, String lastUpdated, String profiles, Boolean active, String status) {
    }
}

