/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractResource;
import dev.dsf.fhir.adapter.ElementSystemValue;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MetadataResource;

public abstract class AbstractMetdataResource<R extends MetadataResource>
extends AbstractResource<R> {
    private final Predicate<R> hasIdentifier;
    private final Function<R, List<Identifier>> getIdentifier;

    public AbstractMetdataResource(Class<R> resourceType) {
        this(resourceType, (Predicate<R>)null, (Function<R, List<Identifier>>)null);
    }

    public AbstractMetdataResource(Class<R> resourceType, Predicate<R> hasIdentifier, Function<R, List<Identifier>> getIdentifier) {
        super(resourceType, AbstractResource.ActiveOrStatus.status(MetadataResource::hasStatusElement, MetadataResource::getStatusElement));
        this.hasIdentifier = hasIdentifier;
        this.getIdentifier = getIdentifier;
    }

    @Override
    protected void doSetAdditionalVariables(BiConsumer<String, Object> variables, R resource) {
        String url = this.getUri(resource, MetadataResource::hasUrlElement, MetadataResource::getUrlElement);
        String version = this.getString(resource, MetadataResource::hasVersionElement, MetadataResource::getVersionElement);
        String urlAndVersion = (url != null ? url : "") + " | " + (version != null ? version : "");
        List<ElementSystemValue> identifier = this.hasIdentifier != null && this.getIdentifier != null ? this.getIdentifiers(resource, this.hasIdentifier, this.getIdentifier) : null;
        String name = this.getString(resource, MetadataResource::hasNameElement, MetadataResource::getNameElement);
        String title = this.getString(resource, MetadataResource::hasTitleElement, MetadataResource::getTitleElement);
        Boolean experimental = this.getBoolean(resource, MetadataResource::hasExperimentalElement, MetadataResource::getExperimentalElement);
        String date = this.getDateTime(resource, MetadataResource::hasDateElement, MetadataResource::getDateElement);
        variables.accept("metadataResource", new Element(urlAndVersion, identifier, name, title, experimental, date));
    }

    private record Element(String urlAndVersion, List<ElementSystemValue> identifier, String name, String title, Boolean experimental, String date) {
    }
}

