/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.websocket;

import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.subscription.WebSocketSubscriptionManager;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.PongMessage;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ServerEndpoint
extends Endpoint
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ServerEndpoint.class);
    public static final String PATH = "/ws";
    public static final String USER_PROPERTY = ServerEndpoint.class.getName() + ".user";
    private static final String PINGER_PROPERTY = ServerEndpoint.class.getName() + ".pinger";
    private static final String BIND_MESSAGE_START = "bind ";
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private final WebSocketSubscriptionManager subscriptionManager;

    public ServerEndpoint(WebSocketSubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.subscriptionManager, "subscriptionManager");
    }

    public void onOpen(final Session session, EndpointConfig config) {
        final Principal principal = session.getUserPrincipal();
        if (principal == null || !(principal instanceof Identity) || !((Identity)principal).hasDsfRole((DsfRole)FhirServerRole.WEBSOCKET)) {
            logger.warn("No user in session or user is missing role {}, closing websocket, session {}", (Object)FhirServerRole.WEBSOCKET, (Object)session.getId());
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "Forbidden"));
            }
            catch (IOException e) {
                logger.debug("Error while closing websocket, session {}", (Object)session.getId(), (Object)e);
                logger.warn("Error while closing websocket, session {}: {} - {}", new Object[]{session.getId(), e.getClass().getName(), e.getMessage()});
            }
            return;
        }
        logger.info("Websocket open, session {}, identity '{}'", (Object)session.getId(), (Object)(principal == null ? null : principal.getName()));
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                logger.debug("Websocket message received, session {}: {}", (Object)session.getId(), (Object)message);
                if (message != null && !message.isBlank() && message.startsWith(ServerEndpoint.BIND_MESSAGE_START)) {
                    String subscriptionIdPart = message.substring(ServerEndpoint.BIND_MESSAGE_START.length());
                    logger.debug("Websocket bind message received, session {}, subscription: {}", (Object)session.getId(), (Object)subscriptionIdPart);
                    ServerEndpoint.this.subscriptionManager.bind((Identity)principal, session, subscriptionIdPart);
                }
            }
        });
        ScheduledFuture<?> pinger = this.scheduler.scheduleWithFixedDelay(() -> this.ping(session), 28L, 28L, TimeUnit.SECONDS);
        session.getUserProperties().put(PINGER_PROPERTY, pinger);
    }

    private void ping(final Session session) {
        final byte[] send = new byte[32];
        ThreadLocalRandom.current().nextBytes(send);
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<PongMessage>(){

            public void onMessage(PongMessage message) {
                byte[] read = new byte[32];
                message.getApplicationData().get(read);
                logger.trace("Pong frame received, session {}: {}", (Object)session.getId(), (Object)Hex.encodeHexString((byte[])read));
                if (!Arrays.equals(send, read)) {
                    logger.warn("Ping frame data not equal to pong frame data, session {}: {} vs. {}", new Object[]{session.getId(), Hex.encodeHexString((byte[])send), Hex.encodeHexString((byte[])read)});
                }
                session.removeMessageHandler((MessageHandler)this);
            }
        });
        try {
            logger.trace("Sending ping frame, session {}: {}", (Object)session.getId(), (Object)Hex.encodeHexString((byte[])send));
            session.getAsyncRemote().sendPing(ByteBuffer.wrap(send));
        }
        catch (IOException | IllegalArgumentException e) {
            logger.debug("Error while sending ping frame, session {}", (Object)session.getId(), (Object)e);
            logger.warn("Error while sending ping frame, session {}: {} - {}", new Object[]{session.getId(), e.getClass().getName(), e.getMessage()});
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        logger.info("Websocket closed, session {}: {} - {}", new Object[]{session.getId(), closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase()});
        this.subscriptionManager.close(session.getId());
        ScheduledFuture pinger = (ScheduledFuture)session.getUserProperties().get(PINGER_PROPERTY);
        if (pinger != null) {
            pinger.cancel(true);
        }
    }

    public void onError(Session session, Throwable throwable) {
        if (throwable == null) {
            logger.info("Websocket closed with error, session {}: unknown error", (Object)session.getId());
        } else {
            logger.debug("Websocket closed with error, session {}", (Object)session.getId(), (Object)throwable);
            logger.info("Websocket closed with error, session {}: {} - {}", new Object[]{session.getId(), throwable.getClass().getName(), this.getMessages(throwable)});
        }
    }

    private String getMessages(Throwable e) {
        StringBuilder b = new StringBuilder();
        if (e != null) {
            if (e.getMessage() != null) {
                b.append(e.getMessage());
            }
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (cause.getMessage() == null) continue;
                b.append(' ');
                b.append(cause.getMessage());
            }
        }
        return b.toString();
    }

    public void destroy() throws Exception {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
                if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                    logger.warn("EventEndpoint scheduler did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

