/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.webservice.jaxrs;

import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.webservice.jaxrs.AbstractResourceServiceJaxrs;
import dev.dsf.fhir.webservice.specification.BinaryService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="Binary")
public class BinaryServiceJaxrs
extends AbstractResourceServiceJaxrs<Binary, BinaryService>
implements BinaryService {
    public static final String PATH = "Binary";
    private static final Logger logger = LoggerFactory.getLogger(BinaryServiceJaxrs.class);
    private final String[] FHIR_MEDIA_TYPES = new String[]{"application/fhir+xml", "application/fhir+json", "application/xml+fhir", "application/json+fhir"};
    private final ParameterConverter parameterConverter;

    public BinaryServiceJaxrs(BinaryService delegate, ParameterConverter parameterConverter) {
        super(delegate);
        this.parameterConverter = parameterConverter;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Objects.requireNonNull(this.parameterConverter, "parameterConverter");
    }

    @Override
    @POST
    @Consumes
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response create(InputStream in, @Context UriInfo uri, @Context HttpHeaders headers) {
        Response response;
        block8: {
            logger.trace("POST {}", (Object)uri.getRequestUri().toString());
            InputStream inputStream = in;
            try {
                String securityContext = this.getSecurityContext(headers);
                String contentType = this.getContentType(headers);
                byte[] content = in.readAllBytes();
                Binary resource = this.createBinary(contentType, content, securityContext);
                response = ((BinaryService)this.delegate).create(resource, uri, headers);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new WebApplicationException((Throwable)e);
                }
            }
            inputStream.close();
        }
        return response;
    }

    private Binary createBinary(String contentType, byte[] content, String securityContextReference) {
        Binary resource = new Binary();
        resource.setContentType(contentType);
        resource.setContent(content);
        resource.setSecurityContext(new Reference(securityContextReference));
        return resource;
    }

    private String getSecurityContext(HttpHeaders headers) {
        return this.getHeaderValueOrThrowBadRequest(headers, "X-Security-Context");
    }

    private String getContentType(HttpHeaders headers) {
        return this.getHeaderValueOrThrowBadRequest(headers, "Content-Type");
    }

    private String getHeaderValueOrThrowBadRequest(HttpHeaders headers, String header) {
        List headerValue = headers.getRequestHeader(header);
        if (headerValue != null && headerValue.size() == 1) {
            String hV0 = (String)headerValue.get(0);
            if (hV0 != null && !hV0.isBlank()) {
                return hV0;
            }
            logger.warn("{} header found, no value, sending {}", (Object)header, (Object)Response.Status.BAD_REQUEST);
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (headerValue != null && headerValue.size() > 1) {
            logger.warn("{} header found, more than one value, sending {}", (Object)header, (Object)Response.Status.BAD_REQUEST);
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        headerValue = headers.getRequestHeader(header.toLowerCase());
        if (headerValue != null && headerValue.size() == 1) {
            String hV0 = (String)headerValue.get(0);
            if (hV0 != null && !hV0.isBlank()) {
                return hV0;
            }
            logger.warn("{} header found, no value, sending {}", (Object)header, (Object)Response.Status.BAD_REQUEST);
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (headerValue != null && headerValue.size() > 1) {
            logger.warn("{} header found, more than one value, sending {}", (Object)header, (Object)Response.Status.BAD_REQUEST);
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        logger.warn("{} header not found, sending {}", (Object)header, (Object)Response.Status.BAD_REQUEST);
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @Override
    @GET
    @Path(value="/{id}")
    @Produces
    public Response read(@PathParam(value="id") String id, @Context UriInfo uri, @Context HttpHeaders headers) {
        Response read = super.read(id, uri, headers);
        Object object = read.getEntity();
        if (object instanceof Binary) {
            Binary binary = (Binary)object;
            if (!this.isValidFhirRequest(uri, headers)) {
                if (this.mediaTypeMatches(headers, binary)) {
                    return this.toStream(binary);
                }
                return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
            }
        }
        return read;
    }

    private boolean mediaTypeMatches(HttpHeaders headers, Binary binary) {
        MediaType binaryMediaType = MediaType.valueOf((String)binary.getContentType());
        return headers.getAcceptableMediaTypes() != null && headers.getAcceptableMediaTypes().stream().anyMatch(acceptType -> acceptType.isCompatible(binaryMediaType));
    }

    private Response toStream(Binary binary) {
        String contentType = binary.getContentType();
        byte[] content = binary.getContent();
        Response.ResponseBuilder b = Response.status((Response.Status)Response.Status.OK).entity((Object)new ByteArrayInputStream(content));
        b = b.type(contentType);
        if (binary.getMeta() != null && binary.getMeta().getLastUpdated() != null && binary.getMeta().getVersionId() != null) {
            b = b.lastModified(binary.getMeta().getLastUpdated());
            b = b.tag(new EntityTag(binary.getMeta().getVersionId(), true));
        }
        if (binary.hasSecurityContext() && binary.getSecurityContext().hasReference()) {
            b.header("X-Security-Context", (Object)binary.getSecurityContext().getReference());
        }
        b = b.cacheControl(ResponseGenerator.PRIVATE_NO_CACHE_NO_TRANSFORM);
        return b.build();
    }

    @Override
    @GET
    @Path(value="/{id}/_history/{version}")
    @Produces
    public Response vread(@PathParam(value="id") String id, @PathParam(value="version") long version, @Context UriInfo uri, @Context HttpHeaders headers) {
        Response read = super.vread(id, version, uri, headers);
        Object object = read.getEntity();
        if (object instanceof Binary) {
            Binary binary = (Binary)object;
            if (!this.isValidFhirRequest(uri, headers)) {
                if (this.mediaTypeMatches(headers, binary)) {
                    return this.toStream(binary);
                }
                return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
            }
        }
        return read;
    }

    private boolean isValidFhirRequest(UriInfo uri, HttpHeaders headers) {
        if (uri.getQueryParameters().containsKey((Object)"_format")) {
            this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers);
            return true;
        }
        List types = headers.getAcceptableMediaTypes();
        MediaType accept = types == null ? null : (MediaType)types.get(0);
        return Arrays.stream(this.FHIR_MEDIA_TYPES).anyMatch(f -> f.equals(accept.toString()));
    }

    @Override
    @PUT
    @Path(value="/{id}")
    @Consumes
    @Produces(value={"application/xml+fhir", "application/fhir+xml", "application/xml", "application/json+fhir", "application/fhir+json", "application/json", "text/html"})
    public Response update(@PathParam(value="id") String id, InputStream in, @Context UriInfo uri, @Context HttpHeaders headers) {
        Response response;
        block8: {
            logger.trace("PUT {}", (Object)uri.getRequestUri().toString());
            InputStream inputStream = in;
            try {
                String securityContext = this.getSecurityContext(headers);
                String contentType = this.getContentType(headers);
                byte[] content = in.readAllBytes();
                Binary resource = this.createBinary(contentType, content, securityContext);
                response = ((BinaryService)this.delegate).update(id, resource, uri, headers);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new WebApplicationException((Throwable)e);
                }
            }
            inputStream.close();
        }
        return response;
    }
}

