/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.webservice.impl;

import dev.dsf.fhir.dao.command.CommandFactory;
import dev.dsf.fhir.dao.command.CommandList;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.history.HistoryService;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.webservice.base.AbstractBasicService;
import dev.dsf.fhir.webservice.specification.RootService;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Resource;
import org.springframework.beans.factory.InitializingBean;

public class RootServiceImpl
extends AbstractBasicService
implements RootService,
InitializingBean {
    private final CommandFactory commandFactory;
    private final ResponseGenerator responseGenerator;
    private final ParameterConverter parameterConverter;
    private final ExceptionHandler exceptionHandler;
    private final ReferenceCleaner referenceCleaner;
    private final HistoryService historyService;

    public RootServiceImpl(CommandFactory commandFactory, ResponseGenerator responseGenerator, ParameterConverter parameterConverter, ExceptionHandler exceptionHandler, ReferenceCleaner referenceCleaner, HistoryService historyService) {
        this.commandFactory = commandFactory;
        this.responseGenerator = responseGenerator;
        this.parameterConverter = parameterConverter;
        this.exceptionHandler = exceptionHandler;
        this.referenceCleaner = referenceCleaner;
        this.historyService = historyService;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.commandFactory, "commandFactory");
        Objects.requireNonNull(this.responseGenerator, "responseGenerator");
        Objects.requireNonNull(this.parameterConverter, "parameterConverter");
        Objects.requireNonNull(this.exceptionHandler, "exceptionHandler");
        Objects.requireNonNull(this.referenceCleaner, "referenceCleaner");
        Objects.requireNonNull(this.historyService, "historyService");
    }

    @Override
    public Response root(UriInfo uri, HttpHeaders headers) {
        OperationOutcome outcome = this.responseGenerator.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "This is the base URL of the FHIR server. GET method not allowed, use POST to execute batch and transaction Bundle resources");
        return this.responseGenerator.response(Response.Status.METHOD_NOT_ALLOWED, (Resource)outcome, this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).allow(new String[]{"POST"}).build();
    }

    @Override
    public Response handleBundle(Bundle bundle, UriInfo uri, HttpHeaders headers) {
        this.referenceCleaner.cleanReferenceResourcesIfBundle((Resource)bundle);
        CommandList commands = this.exceptionHandler.handleBadBundleException(() -> this.commandFactory.createCommands(bundle, this.getCurrentIdentity(), this.parameterConverter.getPreferReturn(headers), this.parameterConverter.getPreferHandling(headers)));
        Bundle result = commands.execute();
        return this.responseGenerator.response(Response.Status.OK, (Resource)result, this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
    }

    @Override
    public Response history(UriInfo uri, HttpHeaders headers) {
        Bundle history = this.historyService.getHistory(this.getCurrentIdentity(), uri, headers);
        return this.responseGenerator.response(Response.Status.OK, this.referenceCleaner.cleanLiteralReferences((Resource)history), this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
    }
}

