/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.subscription;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.parser.IParser;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authorization.AuthorizationRule;
import dev.dsf.fhir.authorization.AuthorizationRuleProvider;
import dev.dsf.fhir.dao.SubscriptionDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.event.Event;
import dev.dsf.fhir.event.EventHandler;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.search.Matcher;
import dev.dsf.fhir.subscription.MatcherFactory;
import dev.dsf.fhir.subscription.ReadWriteMap;
import dev.dsf.fhir.subscription.WebSocketSubscriptionManager;
import jakarta.websocket.CloseReason;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.Session;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class WebSocketSubscriptionManagerImpl
implements WebSocketSubscriptionManager,
EventHandler,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketSubscriptionManagerImpl.class);
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final DaoProvider daoProvider;
    private final SubscriptionDao subscriptionDao;
    private final ExceptionHandler exceptionHandler;
    private final MatcherFactory matcherFactory;
    private final FhirContext fhirContext;
    private final AuthorizationRuleProvider authorizationRuleProvider;
    private final AtomicBoolean firstCall = new AtomicBoolean(true);
    private final ReadWriteMap<String, Subscription> subscriptionsByIdPart = new ReadWriteMap();
    private final ReadWriteMap<Class<? extends Resource>, List<SubscriptionAndMatcher>> matchersByResource = new ReadWriteMap();
    private final ReadWriteMap<String, List<SessionIdAndRemoteAsync>> asyncRemotesBySubscriptionIdPart = new ReadWriteMap();

    public WebSocketSubscriptionManagerImpl(DaoProvider daoProvider, ExceptionHandler exceptionHandler, MatcherFactory matcherFactory, FhirContext fhirContext, AuthorizationRuleProvider authorizationRuleProvider) {
        this.daoProvider = daoProvider;
        this.subscriptionDao = daoProvider.getSubscriptionDao();
        this.exceptionHandler = exceptionHandler;
        this.matcherFactory = matcherFactory;
        this.fhirContext = fhirContext;
        this.authorizationRuleProvider = authorizationRuleProvider;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.daoProvider, "daoProvider");
        Objects.requireNonNull(this.subscriptionDao, "subscriptionDao");
        Objects.requireNonNull(this.exceptionHandler, "exceptionHandler");
        Objects.requireNonNull(this.matcherFactory, "matcherFactory");
        Objects.requireNonNull(this.fhirContext, "fhirContext");
        Objects.requireNonNull(this.authorizationRuleProvider, "authorizationRuleProvider");
    }

    private void refreshMatchers() {
        logger.info("Refreshing subscriptions");
        this.firstCall.set(false);
        try {
            List<Subscription> subscriptions = this.subscriptionDao.readByStatus(Subscription.SubscriptionStatus.ACTIVE);
            HashMap<Class<? extends Resource>, ArrayList<SubscriptionAndMatcher>> matchers = new HashMap<Class<? extends Resource>, ArrayList<SubscriptionAndMatcher>>();
            for (Subscription subscription : subscriptions) {
                Optional<Matcher> matcher = this.matcherFactory.createMatcher(subscription.getCriteria());
                if (!matcher.isPresent()) continue;
                if (matchers.containsKey(matcher.get().getResourceType())) {
                    ((List)matchers.get(matcher.get().getResourceType())).add(new SubscriptionAndMatcher(subscription, matcher.get()));
                    continue;
                }
                matchers.put(matcher.get().getResourceType(), new ArrayList<SubscriptionAndMatcher>(Collections.singletonList(new SubscriptionAndMatcher(subscription, matcher.get()))));
            }
            this.matchersByResource.replaceAll(matchers);
            this.subscriptionsByIdPart.replaceAll(subscriptions.stream().collect(Collectors.toMap(s -> s.getIdElement().getIdPart(), Function.identity())));
            logger.debug("Current active subscription-ids (after refreshing): {}", this.subscriptionsByIdPart.getAllKeys());
        }
        catch (SQLException e) {
            logger.debug("Error while accessing DB", (Throwable)e);
            logger.error("Error while accessing DB: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
    }

    public void destroy() throws Exception {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    logger.warn("EventManager executor did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void handleEvents(List<Event> events) {
        this.executor.execute(() -> this.doHandleEventsAndRefreshMatchers(events));
    }

    private void doHandleEventsAndRefreshMatchers(List<Event> events) {
        if (events.stream().anyMatch(e -> e.getResource() instanceof Subscription || this.firstCall.get())) {
            this.refreshMatchers();
        }
        events.stream().forEach(this::doHandleEvent);
    }

    @Override
    public void handleEvent(Event event) {
        this.executor.execute(() -> this.doHandleEventAndRefreshMatchers(event));
    }

    private void doHandleEventAndRefreshMatchers(Event event) {
        if (event.getResource() instanceof Subscription || this.firstCall.get()) {
            this.refreshMatchers();
        }
        this.doHandleEvent(event);
    }

    private void doHandleEvent(Event event) {
        logger.debug("handling event {} for resource of type {} with id {}", new Object[]{event.getClass().getSimpleName(), event.getResourceType().getAnnotation(ResourceDef.class).name(), event.getId()});
        Optional<List<SubscriptionAndMatcher>> optMatchers = this.matchersByResource.get(event.getResourceType());
        if (optMatchers.isEmpty()) {
            logger.debug("No subscriptions for event {} for resource of type {} with id {}", new Object[]{event.getClass().getSimpleName(), event.getResourceType().getAnnotation(ResourceDef.class).name(), event.getId()});
            return;
        }
        List<SubscriptionAndMatcher> matchingSubscriptions = optMatchers.get().stream().filter(sAndM -> sAndM.matches(event.getResource(), this.daoProvider)).collect(Collectors.toList());
        if (matchingSubscriptions.isEmpty()) {
            logger.debug("No matching subscriptions for event {} for resource of type {} with id {}", new Object[]{event.getClass().getSimpleName(), event.getResourceType().getAnnotation(ResourceDef.class).name(), event.getId()});
            return;
        }
        matchingSubscriptions.forEach(sAndM -> this.doHandleEventWithSubscription(sAndM.subscription, event));
    }

    private void doHandleEventWithSubscription(Subscription s, Event event) {
        Optional<List<SessionIdAndRemoteAsync>> optRemotes = this.asyncRemotesBySubscriptionIdPart.get(s.getIdElement().getIdPart());
        if (optRemotes.isEmpty()) {
            logger.debug("No remotes connected to subscription with id {}", (Object)s.getIdElement().getIdPart());
            return;
        }
        Object text = "application/fhir+json".equals(s.getChannel().getPayload()) ? this.newJsonParser().encodeResourceToString((IBaseResource)event.getResource()) : ("application/fhir+xml".contentEquals(s.getChannel().getPayload()) ? this.newXmlParser().encodeResourceToString((IBaseResource)event.getResource()) : "ping " + s.getIdElement().getIdPart());
        logger.debug("Calling {} remote{} connected to subscription with id {}", new Object[]{optRemotes.get().size(), optRemotes.get().size() != 1 ? "s" : "", s.getIdElement().getIdPart()});
        ArrayList remotes = new ArrayList(optRemotes.get());
        remotes.stream().filter(r -> this.userHasReadAccess((SessionIdAndRemoteAsync)r, event)).forEach(arg_0 -> this.lambda$doHandleEventWithSubscription$7((String)text, arg_0));
    }

    private IParser newXmlParser() {
        return this.configureParser(this.fhirContext.newXmlParser());
    }

    private IParser newJsonParser() {
        return this.configureParser(this.fhirContext.newJsonParser());
    }

    private IParser configureParser(IParser p) {
        p.setStripVersionsFromReferences(Boolean.valueOf(false));
        p.setOverrideResourceIdWithBundleEntryFullUrl(Boolean.valueOf(false));
        return p;
    }

    private boolean userHasReadAccess(SessionIdAndRemoteAsync sessionAndRemote, Event event) {
        Optional<AuthorizationRule<?>> optRule = this.authorizationRuleProvider.getAuthorizationRule(event.getResourceType());
        if (optRule.isPresent()) {
            AuthorizationRule<?> rule = optRule.get();
            Optional<String> optReason = rule.reasonReadAllowed(sessionAndRemote.identity, event.getResource());
            if (optReason.isPresent()) {
                logger.info("Sending event {} to user {}, read of {} allowed {}", new Object[]{event.getClass().getSimpleName(), sessionAndRemote.identity.getName(), event.getResourceType().getSimpleName(), optReason.get()});
                return true;
            }
            logger.warn("Skipping event {} for user {}, read of {} not allowed", new Object[]{event.getClass().getSimpleName(), sessionAndRemote.identity.getName(), event.getResourceType().getSimpleName()});
            return false;
        }
        logger.warn("Skipping event {} for user {}, no authorization rule for resource of type {} found", new Object[]{event.getClass().getSimpleName(), sessionAndRemote.identity.getName(), event.getResourceType().getSimpleName()});
        return false;
    }

    private void send(SessionIdAndRemoteAsync sessionAndRemote, String text) {
        try {
            sessionAndRemote.remoteAsync.sendText(text);
        }
        catch (Exception e) {
            logger.debug("Error while sending event to remote with session id {}: {} - {}", (Object)sessionAndRemote.sessionId, (Object)e);
            logger.warn("Error while sending event to remote with session id {}: {} - {}", new Object[]{sessionAndRemote.sessionId, e.getClass().getName(), e.getMessage()});
        }
    }

    @Override
    public void bind(Identity identity, Session session, String subscriptionIdPart) {
        if (this.firstCall.get()) {
            this.refreshMatchers();
        }
        if (this.subscriptionsByIdPart.containsKey(subscriptionIdPart)) {
            logger.debug("Binding websocket session {} to subscription {}", (Object)session.getId(), (Object)subscriptionIdPart);
            this.asyncRemotesBySubscriptionIdPart.replace(subscriptionIdPart, list -> {
                if (list == null) {
                    ArrayList<SessionIdAndRemoteAsync> newList = new ArrayList<SessionIdAndRemoteAsync>();
                    newList.add(new SessionIdAndRemoteAsync(identity, session.getId(), session.getAsyncRemote()));
                    return newList;
                }
                list.add(new SessionIdAndRemoteAsync(identity, session.getId(), session.getAsyncRemote()));
                return list;
            });
            session.getAsyncRemote().sendText("bound " + subscriptionIdPart);
        } else {
            logger.warn("Could not bind websocket session {} to subscription {}, subscription not found", (Object)session.getId(), (Object)subscriptionIdPart);
            logger.debug("Current active subscription-ids: {}", this.subscriptionsByIdPart.getAllKeys());
            this.closeNotFound(identity, session, subscriptionIdPart);
        }
    }

    private void closeNotFound(Identity identity, Session session, String subscriptionIdPart) {
        try {
            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, "Subscription with " + subscriptionIdPart + " not found"));
        }
        catch (IOException e) {
            logger.warn("Error while closing websocket with user {}, session {}, {}", new Object[]{identity.getName(), session.getId(), e.getMessage()});
            logger.debug("Error while closing websocket", (Throwable)e);
        }
    }

    @Override
    public void close(String sessionId) {
        logger.debug("Removing websocket session {}", (Object)sessionId);
        this.asyncRemotesBySubscriptionIdPart.removeWhereValueMatches(List::isEmpty, list -> list.remove(new SessionIdAndRemoteAsync(null, sessionId, null)));
    }

    private /* synthetic */ void lambda$doHandleEventWithSubscription$7(String text, SessionIdAndRemoteAsync r) {
        this.send(r, text);
    }

    private static class SubscriptionAndMatcher {
        final Subscription subscription;
        final Matcher matcher;

        SubscriptionAndMatcher(Subscription subscription, Matcher matcher) {
            this.subscription = subscription;
            this.matcher = matcher;
        }

        boolean matches(Resource resource, DaoProvider daoProvider) {
            try {
                this.matcher.resloveReferencesForMatching(resource, daoProvider);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return this.matcher.matches(resource);
        }
    }

    private static class SessionIdAndRemoteAsync {
        final Identity identity;
        final String sessionId;
        final RemoteEndpoint.Async remoteAsync;

        SessionIdAndRemoteAsync(Identity identity, String sessionId, RemoteEndpoint.Async remoteAsync) {
            this.identity = identity;
            this.sessionId = sessionId;
            this.remoteAsync = remoteAsync;
        }

        public int hashCode() {
            return Objects.hash(this.sessionId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SessionIdAndRemoteAsync other = (SessionIdAndRemoteAsync)obj;
            return Objects.equals(this.sessionId, other.sessionId);
        }
    }
}

