/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.subscription;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ReadWriteMap<K, V> {
    private final Map<K, V> map = new HashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock r = this.lock.readLock();
    private final Lock w = this.lock.writeLock();

    public Optional<V> get(Object key) {
        this.r.lock();
        try {
            Optional<V> optional = Optional.ofNullable(this.map.get(key));
            return optional;
        }
        finally {
            this.r.unlock();
        }
    }

    public Set<K> getAllKeys() {
        this.r.lock();
        try {
            Set<K> set = this.map.keySet();
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    public void replaceAll(Map<K, V> map) {
        this.w.lock();
        try {
            this.map.clear();
            this.map.putAll(map);
        }
        finally {
            this.w.unlock();
        }
    }

    public void replace(K key, Function<V, V> put) {
        this.w.lock();
        try {
            this.map.put(key, put.apply(this.map.get(key)));
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWhereValueMatches(Predicate<V> remove, Consumer<V> change) {
        this.w.lock();
        try {
            Iterator<Map.Entry<K, V>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                change.accept(entry.getValue());
                if (!remove.test(entry.getValue())) continue;
                iterator.remove();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public boolean containsKey(Object key) {
        this.r.lock();
        try {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }
}

