/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import dev.dsf.fhir.authorization.ActivityDefinitionAuthorizationRule;
import dev.dsf.fhir.authorization.AuthorizationRule;
import dev.dsf.fhir.authorization.AuthorizationRuleProvider;
import dev.dsf.fhir.authorization.AuthorizationRuleProviderImpl;
import dev.dsf.fhir.authorization.BinaryAuthorizationRule;
import dev.dsf.fhir.authorization.BundleAuthorizationRule;
import dev.dsf.fhir.authorization.CodeSystemAuthorizationRule;
import dev.dsf.fhir.authorization.DocumentReferenceAuthorizationRule;
import dev.dsf.fhir.authorization.EndpointAuthorizationRule;
import dev.dsf.fhir.authorization.GroupAuthorizationRule;
import dev.dsf.fhir.authorization.HealthcareServiceAuthorizationRule;
import dev.dsf.fhir.authorization.LibraryAuthorizationRule;
import dev.dsf.fhir.authorization.LocationAuthorizationRule;
import dev.dsf.fhir.authorization.MeasureAuthorizationRule;
import dev.dsf.fhir.authorization.MeasureReportAuthorizationRule;
import dev.dsf.fhir.authorization.NamingSystemAuthorizationRule;
import dev.dsf.fhir.authorization.OrganizationAffiliationAuthorizationRule;
import dev.dsf.fhir.authorization.OrganizationAuthorizationRule;
import dev.dsf.fhir.authorization.PatientAuthorizationRule;
import dev.dsf.fhir.authorization.PractitionerAuthorizationRule;
import dev.dsf.fhir.authorization.PractitionerRoleAuthorizationRule;
import dev.dsf.fhir.authorization.ProvenanceAuthorizationRule;
import dev.dsf.fhir.authorization.QuestionnaireAuthorizationRule;
import dev.dsf.fhir.authorization.QuestionnaireResponseAuthorizationRule;
import dev.dsf.fhir.authorization.ResearchStudyAuthorizationRule;
import dev.dsf.fhir.authorization.RootAuthorizationRule;
import dev.dsf.fhir.authorization.StructureDefinitionAuthorizationRule;
import dev.dsf.fhir.authorization.SubscriptionAuthorizationRule;
import dev.dsf.fhir.authorization.TaskAuthorizationRule;
import dev.dsf.fhir.authorization.ValueSetAuthorizationRule;
import dev.dsf.fhir.authorization.process.ProcessAuthorizationHelper;
import dev.dsf.fhir.authorization.process.ProcessAuthorizationHelperImpl;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.authorization.read.ReadAccessHelperImpl;
import dev.dsf.fhir.dao.command.AuthorizationHelper;
import dev.dsf.fhir.dao.command.AuthorizationHelperImpl;
import dev.dsf.fhir.spring.config.AuthenticationConfig;
import dev.dsf.fhir.spring.config.DaoConfig;
import dev.dsf.fhir.spring.config.FhirConfig;
import dev.dsf.fhir.spring.config.HelperConfig;
import dev.dsf.fhir.spring.config.PropertiesConfig;
import dev.dsf.fhir.spring.config.ReferenceConfig;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.ValueSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthorizationConfig {
    @Autowired
    private AuthenticationConfig authenticationConfig;
    @Autowired
    private DaoConfig daoConfig;
    @Autowired
    private HelperConfig helperConfig;
    @Autowired
    private PropertiesConfig propertiesConfig;
    @Autowired
    private ReferenceConfig referenceConfig;
    @Autowired
    private FhirConfig fhirConfig;

    @Bean
    public ReadAccessHelper readAccessHelper() {
        return new ReadAccessHelperImpl();
    }

    @Bean
    public ProcessAuthorizationHelper processAuthorizationHelper() {
        return new ProcessAuthorizationHelperImpl();
    }

    @Bean
    public AuthorizationRule<ActivityDefinition> activityDefinitionAuthorizationRule() {
        return new ActivityDefinitionAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter(), this.processAuthorizationHelper());
    }

    @Bean
    public AuthorizationRule<Binary> binaryAuthorizationRule() {
        return new BinaryAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter(), this.activityDefinitionAuthorizationRule(), this.bundleAuthorizationRule(), this.codeSystemAuthorizationRule(), this.documentReferenceAuthorizationRule(), this.endpointAuthorizationRule(), this.groupAuthorizationRule(), this.healthcareServiceAuthorizationRule(), this.libraryAuthorizationRule(), this.locationAuthorizationRule(), this.measureAuthorizationRule(), this.measureReportAuthorizationRule(), this.namingSystemAuthorizationRule(), this.organizationAuthorizationRule(), this.organizationAffiliationAuthorizationRule(), this.patientAuthorizationRule(), this.practitionerAuthorizationRule(), this.practitionerRoleAuthorizationRule(), this.provenanceAuthorizationRule(), this.questionnaireAuthorizationRule(), this.questionnaireResponseAuthorizationRule(), this.researchStudyAuthorizationRule(), this.structureDefinitionAuthorizationRule(), this.subscriptionAuthorizationRule(), this.valueSetAuthorizationRule());
    }

    @Bean
    public AuthorizationRule<Bundle> bundleAuthorizationRule() {
        return new BundleAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<CodeSystem> codeSystemAuthorizationRule() {
        return new CodeSystemAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<DocumentReference> documentReferenceAuthorizationRule() {
        return new DocumentReferenceAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<Endpoint> endpointAuthorizationRule() {
        return new EndpointAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<Group> groupAuthorizationRule() {
        return new GroupAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<HealthcareService> healthcareServiceAuthorizationRule() {
        return new HealthcareServiceAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<Library> libraryAuthorizationRule() {
        return new LibraryAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<Location> locationAuthorizationRule() {
        return new LocationAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<Measure> measureAuthorizationRule() {
        return new MeasureAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<MeasureReport> measureReportAuthorizationRule() {
        return new MeasureReportAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<NamingSystem> namingSystemAuthorizationRule() {
        return new NamingSystemAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<Organization> organizationAuthorizationRule() {
        return new OrganizationAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<OrganizationAffiliation> organizationAffiliationAuthorizationRule() {
        return new OrganizationAffiliationAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<Patient> patientAuthorizationRule() {
        return new PatientAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<Practitioner> practitionerAuthorizationRule() {
        return new PractitionerAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<PractitionerRole> practitionerRoleAuthorizationRule() {
        return new PractitionerRoleAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<Provenance> provenanceAuthorizationRule() {
        return new ProvenanceAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<Questionnaire> questionnaireAuthorizationRule() {
        return new QuestionnaireAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<QuestionnaireResponse> questionnaireResponseAuthorizationRule() {
        return new QuestionnaireResponseAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<ResearchStudy> researchStudyAuthorizationRule() {
        return new ResearchStudyAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<StructureDefinition> structureDefinitionAuthorizationRule() {
        return new StructureDefinitionAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<Subscription> subscriptionAuthorizationRule() {
        return new SubscriptionAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRule<Task> taskAuthorizationRule() {
        return new TaskAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter(), this.processAuthorizationHelper(), this.fhirConfig.fhirContext());
    }

    @Bean
    public AuthorizationRule<ValueSet> valueSetAuthorizationRule() {
        return new ValueSetAuthorizationRule(this.daoConfig.daoProvider(), this.propertiesConfig.getServerBaseUrl(), this.referenceConfig.referenceResolver(), this.authenticationConfig.organizationProvider(), this.readAccessHelper(), this.helperConfig.parameterConverter());
    }

    @Bean
    public AuthorizationRuleProvider authorizationRuleProvider() {
        return new AuthorizationRuleProviderImpl(this.activityDefinitionAuthorizationRule(), this.binaryAuthorizationRule(), this.bundleAuthorizationRule(), this.codeSystemAuthorizationRule(), this.documentReferenceAuthorizationRule(), this.endpointAuthorizationRule(), this.groupAuthorizationRule(), this.healthcareServiceAuthorizationRule(), this.libraryAuthorizationRule(), this.locationAuthorizationRule(), this.measureAuthorizationRule(), this.measureReportAuthorizationRule(), this.namingSystemAuthorizationRule(), this.organizationAuthorizationRule(), this.organizationAffiliationAuthorizationRule(), this.patientAuthorizationRule(), this.practitionerAuthorizationRule(), this.practitionerRoleAuthorizationRule(), this.provenanceAuthorizationRule(), this.questionnaireAuthorizationRule(), this.questionnaireResponseAuthorizationRule(), this.researchStudyAuthorizationRule(), this.structureDefinitionAuthorizationRule(), this.subscriptionAuthorizationRule(), this.taskAuthorizationRule(), this.valueSetAuthorizationRule());
    }

    @Bean
    public AuthorizationHelper authorizationHelper() {
        return new AuthorizationHelperImpl(this.authorizationRuleProvider(), this.helperConfig.responseGenerator());
    }

    @Bean
    public AuthorizationRule<Resource> rootAuthorizationRule() {
        return new RootAuthorizationRule();
    }
}

