/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.service;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.authentication.OrganizationIdentityImpl;
import dev.dsf.fhir.dao.command.CommandFactory;
import dev.dsf.fhir.dao.command.CommandList;
import dev.dsf.fhir.prefer.PreferHandlingType;
import dev.dsf.fhir.prefer.PreferReturnType;
import dev.dsf.fhir.service.InitialDataLoader;
import java.util.EnumSet;
import java.util.Objects;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Organization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class InitialDataLoaderImpl
implements InitialDataLoader,
InitializingBean {
    private static final Identity INITIAL_DATA_LOADER;
    private static final Logger logger;
    private final CommandFactory commandFactory;
    private final FhirContext fhirContext;

    public InitialDataLoaderImpl(CommandFactory commandFactory, FhirContext fhirContext) {
        this.commandFactory = commandFactory;
        this.fhirContext = fhirContext;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.commandFactory, "commandFactory");
        Objects.requireNonNull(this.fhirContext, "fhirContext");
    }

    @Override
    public void load(Bundle bundle) {
        if (bundle == null) {
            logger.warn("Not loading 'null' bundle");
            return;
        }
        CommandList commands = this.commandFactory.createCommands(bundle, INITIAL_DATA_LOADER, PreferReturnType.MINIMAL, PreferHandlingType.STRICT);
        logger.debug("Executing command list for bundle with {} entries", (Object)bundle.getEntry().size());
        Bundle result = commands.execute();
        result.getEntry().forEach(this::logResult);
    }

    private void logResult(Bundle.BundleEntryComponent entry) {
        logger.info("Result: {} {}", (Object)entry.getResponse().getLocation(), (Object)entry.getResponse().getStatus());
    }

    static {
        Organization org = new Organization().setName("Initial Data Loader");
        org.addIdentifier().setSystem("http://dsf.dev/sid/organization-identifier").setValue("initial.data.loader");
        INITIAL_DATA_LOADER = new OrganizationIdentityImpl(true, org, EnumSet.of(FhirServerRole.CREATE, FhirServerRole.DELETE, FhirServerRole.UPDATE), null);
        logger = LoggerFactory.getLogger(InitialDataLoaderImpl.class);
    }
}

