/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.parameters.basic.AbstractCanonicalUrlParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.hl7.fhir.r4.model.MetadataResource;

public abstract class AbstractUrlAndVersionParameter<R extends MetadataResource>
extends AbstractCanonicalUrlParameter<R> {
    public static final String PARAMETER_NAME = "url";
    private final String resourceColumn;

    public AbstractUrlAndVersionParameter(Class<R> resourceType, String resourceColumn) {
        super(resourceType, PARAMETER_NAME);
        this.resourceColumn = resourceColumn;
    }

    @Override
    public String getFilterQuery() {
        String versionSubQuery = this.hasVersion() ? " AND " + this.resourceColumn + "->>'version' = ?" : "";
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractCanonicalUrlParameter.UriSearchType.PRECISE -> this.resourceColumn + "->>'url' = ?" + versionSubQuery;
            case AbstractCanonicalUrlParameter.UriSearchType.BELOW -> this.resourceColumn + "->>'url' LIKE ?" + versionSubQuery;
        };
    }

    @Override
    public int getSqlParameterCount() {
        return this.hasVersion() ? 2 : 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        if (subqueryParameterIndex == 1) {
            switch (this.valueAndType.type) {
                case PRECISE: {
                    statement.setString(parameterIndex, this.valueAndType.url);
                    return;
                }
                case BELOW: {
                    statement.setString(parameterIndex, this.valueAndType.url + "%");
                    return;
                }
            }
        } else if (subqueryParameterIndex == 2) {
            statement.setString(parameterIndex, this.valueAndType.version);
        }
    }

    @Override
    protected boolean resourceMatches(R resource) {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractCanonicalUrlParameter.UriSearchType.PRECISE -> {
                if (resource.hasUrl() && Objects.equals(resource.getUrl(), this.valueAndType.url) && (this.valueAndType.version == null || resource.hasVersion() && Objects.equals(resource.getVersion(), this.valueAndType.version))) {
                    yield true;
                }
                yield false;
            }
            case AbstractCanonicalUrlParameter.UriSearchType.BELOW -> resource.hasUrl() && resource.getUrl().startsWith(this.valueAndType.url) && (this.valueAndType.version == null || resource.hasVersion() && Objects.equals(resource.getVersion(), this.valueAndType.version));
        };
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return this.resourceColumn + "->>'url'" + sortDirectionWithSpacePrefix;
    }
}

