/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.parameters.basic.AbstractStringParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hl7.fhir.r4.model.Resource;

public class AbstractNameParameter<R extends Resource>
extends AbstractStringParameter<R> {
    public static final String PARAMETER_NAME = "name";
    private final String resourceColumn;
    private final Predicate<R> hasName;
    private final Function<R, String> getName;

    public AbstractNameParameter(Class<R> resourceType, String resourceColumn, Predicate<R> hasName, Function<R, String> getName) {
        super(resourceType, PARAMETER_NAME);
        this.resourceColumn = resourceColumn;
        this.hasName = hasName;
        this.getName = getName;
    }

    @Override
    public String getFilterQuery() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractStringParameter.StringSearchType.STARTS_WITH, AbstractStringParameter.StringSearchType.CONTAINS -> "lower(" + this.resourceColumn + "->>'name') LIKE ?";
            case AbstractStringParameter.StringSearchType.EXACT -> this.resourceColumn + "->>'name' = ?";
        };
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case STARTS_WITH: {
                statement.setString(parameterIndex, this.valueAndType.value.toLowerCase() + "%");
                return;
            }
            case CONTAINS: {
                statement.setString(parameterIndex, "%" + this.valueAndType.value.toLowerCase() + "%");
                return;
            }
            case EXACT: {
                statement.setString(parameterIndex, this.valueAndType.value);
                return;
            }
        }
    }

    @Override
    protected boolean resourceMatches(R resource) {
        return this.hasName.test(resource) && this.nameMatches(this.getName.apply(resource));
    }

    private boolean nameMatches(String name) {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractStringParameter.StringSearchType.STARTS_WITH -> name.toLowerCase().startsWith(this.valueAndType.value.toLowerCase());
            case AbstractStringParameter.StringSearchType.CONTAINS -> name.toLowerCase().contains(this.valueAndType.value.toLowerCase());
            case AbstractStringParameter.StringSearchType.EXACT -> Objects.equals(name, this.valueAndType.value);
        };
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return this.resourceColumn + "->>'name'" + sortDirectionWithSpacePrefix;
    }
}

