/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractReferenceParameter;
import java.util.List;
import org.hl7.fhir.r4.model.DomainResource;

public abstract class AbstractCanonicalReferenceParameter<R extends DomainResource>
extends AbstractReferenceParameter<R> {
    public AbstractCanonicalReferenceParameter(Class<R> resourceType, String parameterName, String ... targetResourceTypeNames) {
        super(resourceType, parameterName, targetResourceTypeNames);
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        super.doConfigure(errors, queryParameterName, queryParameterValue);
        if (this.valueAndType != null && this.valueAndType.type != null) {
            switch (this.valueAndType.type) {
                case URL: {
                    return;
                }
            }
            errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, queryParameterValue));
            return;
        }
    }
}

