/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractStringParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Subscription;

@SearchQueryParameter.SearchParameterDefinition(name="criteria", definition="http://hl7.org/fhir/SearchParameter/Subscription-criteria", type=Enumerations.SearchParamType.STRING, documentation="The search rules used to determine when to send a notification (always matches exact)")
public class SubscriptionCriteria
extends AbstractStringParameter<Subscription> {
    public static final String PARAMETER_NAME = "criteria";

    public SubscriptionCriteria() {
        super(Subscription.class, PARAMETER_NAME);
    }

    @Override
    public String getFilterQuery() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractStringParameter.StringSearchType.STARTS_WITH, AbstractStringParameter.StringSearchType.CONTAINS -> "lower(subscription->>'criteria') LIKE ?";
            case AbstractStringParameter.StringSearchType.EXACT -> "subscription->>'criteria' = ?";
        };
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case STARTS_WITH: {
                statement.setString(parameterIndex, this.valueAndType.value.toLowerCase() + "%");
                return;
            }
            case CONTAINS: {
                statement.setString(parameterIndex, "%" + this.valueAndType.value.toLowerCase() + "%");
                return;
            }
            case EXACT: {
                statement.setString(parameterIndex, this.valueAndType.value);
                return;
            }
        }
    }

    @Override
    protected boolean resourceMatches(Subscription resource) {
        return resource.hasCriteria() && this.criteriaMatches(resource.getCriteria());
    }

    private boolean criteriaMatches(String criteria) {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractStringParameter.StringSearchType.STARTS_WITH -> criteria.toLowerCase().startsWith(this.valueAndType.value.toLowerCase());
            case AbstractStringParameter.StringSearchType.CONTAINS -> criteria.toLowerCase().contains(this.valueAndType.value.toLowerCase());
            case AbstractStringParameter.StringSearchType.EXACT -> Objects.equals(criteria, this.valueAndType.value);
        };
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "subscription->>'criteria'" + sortDirectionWithSpacePrefix;
    }
}

