/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.dao.GroupDao;
import dev.dsf.fhir.dao.exception.ResourceDeletedException;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.IncludeParameterDefinition;
import dev.dsf.fhir.search.IncludeParts;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractReferenceParameter;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.BaseReference;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.Resource;

@IncludeParameterDefinition(resourceType=ResearchStudy.class, parameterName="enrollment", targetResourceTypes={Group.class})
@SearchQueryParameter.SearchParameterDefinition(name="enrollment", definition="http://dsf.dev/fhir/SearchParameter/ResearchStudy-enrollment", type=Enumerations.SearchParamType.REFERENCE, documentation="Search by research study enrollment")
public class ResearchStudyEnrollment
extends AbstractReferenceParameter<ResearchStudy> {
    private static final String RESOURCE_TYPE_NAME = "ResearchStudy";
    public static final String PARAMETER_NAME = "enrollment";
    private static final String TARGET_RESOURCE_TYPE_NAME = "Group";

    public static List<String> getIncludeParameterValues() {
        return List.of("ResearchStudy:enrollment", "ResearchStudy:enrollment:Group");
    }

    public ResearchStudyEnrollment() {
        super(ResearchStudy.class, PARAMETER_NAME, TARGET_RESOURCE_TYPE_NAME);
    }

    @Override
    public String getFilterQuery() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractReferenceParameter.ReferenceSearchType.ID, AbstractReferenceParameter.ReferenceSearchType.RESOURCE_NAME_AND_ID, AbstractReferenceParameter.ReferenceSearchType.URL, AbstractReferenceParameter.ReferenceSearchType.TYPE_AND_ID, AbstractReferenceParameter.ReferenceSearchType.TYPE_AND_RESOURCE_NAME_AND_ID -> "? IN (SELECT reference->>'reference' FROM jsonb_array_elements(research_study->'enrollment') AS reference)";
            case AbstractReferenceParameter.ReferenceSearchType.IDENTIFIER -> {
                switch (this.valueAndType.identifier.type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CODE: 
                    case CODE_AND_SYSTEM: 
                    case SYSTEM: {
                        yield "(SELECT jsonb_agg(identifier) FROM (SELECT identifier FROM current_groups, jsonb_array_elements(group_json->'identifier') identifier WHERE concat('Group/', group_json->>'id') IN (SELECT reference->>'reference' FROM jsonb_array_elements(research_study->'enrollment') reference) ) AS identifiers) @> ?::jsonb";
                    }
                    case CODE_AND_NO_SYSTEM_PROPERTY: 
                }
                yield "(SELECT count(*) FROM (SELECT identifier FROM current_groups, jsonb_array_elements(group_json->'identifier') identifier WHERE concat('Group/', group_json->>'id') IN (SELECT reference->>'reference' FROM jsonb_array_elements(research_study->'enrollment') reference) ) AS identifiers WHERE identifier->>'value' = ? AND NOT (identifier ?? 'system')) > 0";
            }
        };
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        block0 : switch (this.valueAndType.type) {
            case ID: 
            case RESOURCE_NAME_AND_ID: 
            case TYPE_AND_ID: 
            case TYPE_AND_RESOURCE_NAME_AND_ID: {
                statement.setString(parameterIndex, "Group/" + this.valueAndType.id);
                break;
            }
            case URL: {
                statement.setString(parameterIndex, this.valueAndType.url);
                break;
            }
            case IDENTIFIER: {
                switch (this.valueAndType.identifier.type) {
                    case CODE: {
                        statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.identifier.codeValue + "\"}]");
                        break block0;
                    }
                    case CODE_AND_SYSTEM: {
                        statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.identifier.codeValue + "\", \"system\": \"" + this.valueAndType.identifier.systemValue + "\"}]");
                        break block0;
                    }
                    case CODE_AND_NO_SYSTEM_PROPERTY: {
                        statement.setString(parameterIndex, this.valueAndType.identifier.codeValue);
                        break block0;
                    }
                    case SYSTEM: {
                        statement.setString(parameterIndex, "[{\"system\": \"" + this.valueAndType.identifier.systemValue + "\"}]");
                    }
                }
            }
        }
    }

    @Override
    protected void doResolveReferencesForMatching(ResearchStudy resource, DaoProvider daoProvider) throws SQLException {
        GroupDao dao = daoProvider.getGroupDao();
        for (Reference reference : resource.getEnrollment()) {
            IIdType idType = reference.getReferenceElement();
            try {
                if (idType.hasVersionIdPart()) {
                    dao.readVersion(UUID.fromString(idType.getIdPart()), idType.getVersionIdPartAsLong()).ifPresent(arg_0 -> ((Reference)reference).setResource(arg_0));
                    continue;
                }
                dao.read(UUID.fromString(idType.getIdPart())).ifPresent(arg_0 -> ((Reference)reference).setResource(arg_0));
            }
            catch (ResourceDeletedException resourceDeletedException) {}
        }
    }

    @Override
    protected boolean resourceMatches(ResearchStudy resource) {
        if (AbstractReferenceParameter.ReferenceSearchType.IDENTIFIER.equals((Object)this.valueAndType.type)) {
            return resource.getEnrollment().stream().map(BaseReference::getResource).filter(r -> r instanceof Group).map(r -> (Group)r).map(Group::getIdentifier).flatMap(Collection::stream).anyMatch(AbstractIdentifierParameter.identifierMatches(this.valueAndType.identifier));
        }
        return resource.getEnrollment().stream().map(Reference::getReference).anyMatch(ref -> switch (this.valueAndType.type) {
            case AbstractReferenceParameter.ReferenceSearchType.ID -> ref.equals("Group/" + this.valueAndType.id);
            case AbstractReferenceParameter.ReferenceSearchType.RESOURCE_NAME_AND_ID -> ref.equals(this.valueAndType.resourceName + "/" + this.valueAndType.id);
            case AbstractReferenceParameter.ReferenceSearchType.URL -> ref.equals(this.valueAndType.url);
            default -> false;
        });
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(SELECT string_agg(reference->>'reference', ' ') FROM jsonb_array_elements(research_study->'enrollment') AS reference)";
    }

    @Override
    protected String getIncludeSql(IncludeParts includeParts) {
        if (includeParts.matches(RESOURCE_TYPE_NAME, PARAMETER_NAME, TARGET_RESOURCE_TYPE_NAME)) {
            return "(SELECT jsonb_agg(group_json) FROM current_groups WHERE concat('Group/', group_json->>'id') IN (SELECT reference->>'reference' FROM jsonb_array_elements(research_study->'enrollment') AS reference)) AS groups";
        }
        return null;
    }

    @Override
    protected void modifyIncludeResource(IncludeParts includeParts, Resource resource, Connection connection) {
    }
}

