/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.dao.PractitionerDao;
import dev.dsf.fhir.dao.exception.ResourceDeletedException;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.IncludeParameterDefinition;
import dev.dsf.fhir.search.IncludeParts;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractReferenceParameter;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;

@IncludeParameterDefinition(resourceType=PractitionerRole.class, parameterName="practitioner", targetResourceTypes={Practitioner.class})
@SearchQueryParameter.SearchParameterDefinition(name="practitioner", definition="http://hl7.org/fhir/SearchParameter/PractitionerRole-practitioner", type=Enumerations.SearchParamType.REFERENCE, documentation="Practitioner that is able to provide the defined services for the organization")
public class PractitionerRolePractitioner
extends AbstractReferenceParameter<PractitionerRole> {
    private static final String RESOURCE_TYPE_NAME = "PractitionerRole";
    public static final String PARAMETER_NAME = "practitioner";
    private static final String TARGET_RESOURCE_TYPE_NAME = "Practitioner";
    private static final String PRACTITIONER_IDENTIFIERS_SUBQUERY = "(SELECT practitioner->'identifier' FROM current_practitioners WHERE concat('Practitioner/', practitioner->>'id') = practitioner_role->'practitioner'->>'reference')";

    public static List<String> getIncludeParameterValues() {
        return List.of("PractitionerRole:practitioner", "PractitionerRole:practitioner:Practitioner");
    }

    public PractitionerRolePractitioner() {
        super(PractitionerRole.class, PARAMETER_NAME, TARGET_RESOURCE_TYPE_NAME);
    }

    @Override
    public String getFilterQuery() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractReferenceParameter.ReferenceSearchType.ID, AbstractReferenceParameter.ReferenceSearchType.RESOURCE_NAME_AND_ID, AbstractReferenceParameter.ReferenceSearchType.URL, AbstractReferenceParameter.ReferenceSearchType.TYPE_AND_ID, AbstractReferenceParameter.ReferenceSearchType.TYPE_AND_RESOURCE_NAME_AND_ID -> "practitioner_role->'practitioner'->>'reference' = ?";
            case AbstractReferenceParameter.ReferenceSearchType.IDENTIFIER -> {
                switch (this.valueAndType.identifier.type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CODE: 
                    case CODE_AND_SYSTEM: 
                    case SYSTEM: {
                        yield "(SELECT practitioner->'identifier' FROM current_practitioners WHERE concat('Practitioner/', practitioner->>'id') = practitioner_role->'practitioner'->>'reference') @> ?::jsonb";
                    }
                    case CODE_AND_NO_SYSTEM_PROPERTY: 
                }
                yield "(SELECT count(*) FROM jsonb_array_elements((SELECT practitioner->'identifier' FROM current_practitioners WHERE concat('Practitioner/', practitioner->>'id') = practitioner_role->'practitioner'->>'reference')) identifier WHERE identifier->>'value' = ? AND NOT (identifier ?? 'system')) > 0";
            }
        };
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        block0 : switch (this.valueAndType.type) {
            case ID: 
            case RESOURCE_NAME_AND_ID: 
            case TYPE_AND_ID: 
            case TYPE_AND_RESOURCE_NAME_AND_ID: {
                statement.setString(parameterIndex, "Practitioner/" + this.valueAndType.id);
                break;
            }
            case URL: {
                statement.setString(parameterIndex, this.valueAndType.url);
                break;
            }
            case IDENTIFIER: {
                switch (this.valueAndType.identifier.type) {
                    case CODE: {
                        statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.identifier.codeValue + "\"}]");
                        break block0;
                    }
                    case CODE_AND_SYSTEM: {
                        statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.identifier.codeValue + "\", \"system\": \"" + this.valueAndType.identifier.systemValue + "\"}]");
                        break block0;
                    }
                    case CODE_AND_NO_SYSTEM_PROPERTY: {
                        statement.setString(parameterIndex, this.valueAndType.identifier.codeValue);
                        break block0;
                    }
                    case SYSTEM: {
                        statement.setString(parameterIndex, "[{\"system\": \"" + this.valueAndType.identifier.systemValue + "\"}]");
                    }
                }
            }
        }
    }

    @Override
    protected void doResolveReferencesForMatching(PractitionerRole resource, DaoProvider daoProvider) throws SQLException {
        PractitionerDao dao = daoProvider.getPractitionerDao();
        Reference reference = resource.getPractitioner();
        IIdType idType = reference.getReferenceElement();
        try {
            if (idType.hasVersionIdPart()) {
                dao.readVersion(UUID.fromString(idType.getIdPart()), idType.getVersionIdPartAsLong()).ifPresent(arg_0 -> ((Reference)reference).setResource(arg_0));
            } else {
                dao.read(UUID.fromString(idType.getIdPart())).ifPresent(arg_0 -> ((Reference)reference).setResource(arg_0));
            }
        }
        catch (ResourceDeletedException resourceDeletedException) {
            // empty catch block
        }
    }

    @Override
    protected boolean resourceMatches(PractitionerRole resource) {
        if (AbstractReferenceParameter.ReferenceSearchType.IDENTIFIER.equals((Object)this.valueAndType.type)) {
            IBaseResource iBaseResource = resource.getPractitioner().getResource();
            if (iBaseResource instanceof Practitioner) {
                Practitioner p = (Practitioner)iBaseResource;
                return p.getIdentifier().stream().anyMatch(AbstractIdentifierParameter.identifierMatches(this.valueAndType.identifier));
            }
            return false;
        }
        String ref = resource.getPractitioner().getReference();
        return switch (this.valueAndType.type) {
            case AbstractReferenceParameter.ReferenceSearchType.ID -> ref.equals("Practitioner/" + this.valueAndType.id);
            case AbstractReferenceParameter.ReferenceSearchType.RESOURCE_NAME_AND_ID -> ref.equals(this.valueAndType.resourceName + "/" + this.valueAndType.id);
            case AbstractReferenceParameter.ReferenceSearchType.URL -> ref.equals(this.valueAndType.url);
            default -> false;
        };
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "practitioner_role->'practitioner'->>'reference'";
    }

    @Override
    protected String getIncludeSql(IncludeParts includeParts) {
        if (includeParts.matches(RESOURCE_TYPE_NAME, PARAMETER_NAME, TARGET_RESOURCE_TYPE_NAME)) {
            return "(SELECT jsonb_build_array(practitioner) FROM current_practitioners WHERE concat('Practitioner/', practitioner->>'id') = practitioner_role->'practitioner'->>'reference') AS practitioners";
        }
        return null;
    }

    @Override
    protected void modifyIncludeResource(IncludeParts includeParts, Resource resource, Connection connection) {
    }
}

