/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.IncludeParameterDefinition;
import dev.dsf.fhir.search.IncludeParts;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractCanonicalReferenceParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractReferenceParameter;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Resource;

@IncludeParameterDefinition(resourceType=Measure.class, parameterName="depends-on", targetResourceTypes={Library.class})
@SearchQueryParameter.SearchParameterDefinition(name="depends-on", definition="http://hl7.org/fhir/SearchParameter/Measure-depends-on", type=Enumerations.SearchParamType.REFERENCE, documentation="What resource is being referenced")
public class MeasureDependsOn
extends AbstractCanonicalReferenceParameter<Measure> {
    private static final String RESOURCE_TYPE_NAME = "Measure";
    public static final String PARAMETER_NAME = "depends-on";
    private static final String TARGET_RESOURCE_TYPE_NAME = "Library";

    public static List<String> getIncludeParameterValues() {
        return List.of("Measure:depends-on", "Measure:depends-on:Library");
    }

    public MeasureDependsOn() {
        super(Measure.class, PARAMETER_NAME, TARGET_RESOURCE_TYPE_NAME);
    }

    @Override
    public boolean isDefined() {
        return super.isDefined() && AbstractReferenceParameter.ReferenceSearchType.URL.equals((Object)this.valueAndType.type);
    }

    @Override
    public String getFilterQuery() {
        if (AbstractReferenceParameter.ReferenceSearchType.URL.equals((Object)this.valueAndType.type)) {
            return "(measure->'library' ?? ? OR measure->'relatedArtifact' @> ?::jsonb)";
        }
        return "";
    }

    @Override
    public int getSqlParameterCount() {
        return 2;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        if (AbstractReferenceParameter.ReferenceSearchType.URL.equals((Object)this.valueAndType.type)) {
            if (subqueryParameterIndex == 1) {
                statement.setString(parameterIndex, this.valueAndType.url);
            } else if (subqueryParameterIndex == 2) {
                statement.setString(parameterIndex, "[{\"type\": \"depends-on\", \"resource\": \"" + this.valueAndType.url + "\"}]");
            }
        }
    }

    @Override
    protected void doResolveReferencesForMatching(Measure resource, DaoProvider daoProvider) throws SQLException {
    }

    @Override
    protected boolean resourceMatches(Measure resource) {
        return resource.hasLibrary() && resource.getLibrary().stream().filter(PrimitiveType::hasValue).anyMatch(ref -> ref.equals(this.valueAndType.url));
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(SELECT string_agg(canonical, ' ') FROM jsonb_array_elements(measure->'library') AS canonical)";
    }

    @Override
    protected String getIncludeSql(IncludeParts includeParts) {
        if (includeParts.matches(RESOURCE_TYPE_NAME, PARAMETER_NAME, TARGET_RESOURCE_TYPE_NAME)) {
            return "(SELECT jsonb_agg(library) FROM current_libraries WHERE library->'url' IN (SELECT canonical FROM jsonb_array_elements(measure->'library') AS canonical)) AS libraries";
        }
        return null;
    }

    @Override
    protected void modifyIncludeResource(IncludeParts includeParts, Resource resource, Connection connection) {
    }
}

