/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractCanonicalUrlParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Enumerations;

@SearchQueryParameter.SearchParameterDefinition(name="address", definition="http://hl7.org/fhir/SearchParameter/Endpoint-address", type=Enumerations.SearchParamType.URI, documentation="The address (url) of the endpoint")
public class EndpointAddress
extends AbstractCanonicalUrlParameter<Endpoint> {
    public static final String PARAMETER_NAME = "address";

    public EndpointAddress() {
        super(Endpoint.class, PARAMETER_NAME);
    }

    @Override
    public String getFilterQuery() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractCanonicalUrlParameter.UriSearchType.PRECISE -> "endpoint->>'address' = ?";
            case AbstractCanonicalUrlParameter.UriSearchType.BELOW -> "endpoint->>'address' LIKE ?";
        };
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case PRECISE: {
                statement.setString(parameterIndex, this.valueAndType.url);
                return;
            }
            case BELOW: {
                statement.setString(parameterIndex, this.valueAndType.url + "%");
                return;
            }
        }
    }

    @Override
    protected boolean resourceMatches(Endpoint resource) {
        boolean bl;
        block6: {
            block5: {
                if (!resource.hasAddress()) break block5;
                switch (this.valueAndType.type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case PRECISE: {
                        if (Objects.equals(resource.getAddress(), this.valueAndType.url)) {
                            break;
                        }
                        break block5;
                    }
                    case BELOW: {
                        if (!resource.getAddress().startsWith(this.valueAndType.url)) break block5;
                    }
                }
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "endpoint->>'address'" + sortDirectionWithSpacePrefix;
    }
}

