/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search;

import dev.dsf.fhir.search.SearchQueryIncludeParameter;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.SearchQuerySortParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Resource;

public final class SearchQueryParameterFactory<R extends Resource> {
    private final String name;
    private final List<String> nameModifiers = new ArrayList<String>();
    private final Supplier<SearchQueryParameter<R>> supplier;
    private final Supplier<SearchQueryIncludeParameter<R>> includeSupplier;
    private final List<String> includeParameterValues = new ArrayList<String>();

    public SearchQueryParameterFactory(String name, Supplier<SearchQueryParameter<R>> supplier) {
        this(name, supplier, null);
    }

    public SearchQueryParameterFactory(String name, Supplier<SearchQueryParameter<R>> supplier, List<String> nameModifiers) {
        this(name, supplier, nameModifiers, null, null);
    }

    public SearchQueryParameterFactory(String name, Supplier<SearchQueryParameter<R>> supplier, List<String> nameModifiers, Supplier<SearchQueryIncludeParameter<R>> includeSupplier, List<String> includeParameterValues) {
        this.name = Objects.requireNonNull(name, "name");
        this.supplier = Objects.requireNonNull(supplier, "supplier");
        if (nameModifiers != null) {
            this.nameModifiers.addAll(nameModifiers);
        }
        this.includeSupplier = includeSupplier;
        if (includeParameterValues != null) {
            this.includeParameterValues.addAll(includeParameterValues);
        }
        if (includeSupplier != null ^ includeParameterValues != null) {
            throw new IllegalArgumentException("includeSupplier and includeParameterValues must both be null or not null");
        }
    }

    public String getName() {
        return this.name;
    }

    public Stream<String> getNameAndModifiedNames() {
        return Stream.concat(Stream.of(this.name), this.nameModifiers.stream().map(m -> this.name + m));
    }

    public Stream<String> getSortNames() {
        return Stream.of(this.name, "+" + this.name, "-" + this.name);
    }

    public Stream<String> getIncludeParameterValues() {
        return this.includeParameterValues.stream();
    }

    public SearchQueryParameter<R> createQueryParameter() {
        return this.supplier.get();
    }

    public SearchQuerySortParameter createQuerySortParameter() {
        return this.supplier.get();
    }

    public boolean isIncludeParameter() {
        return this.includeSupplier != null && this.includeParameterValues != null;
    }

    public SearchQueryIncludeParameter<R> createQueryIncludeParameter() {
        return this.includeSupplier.get();
    }
}

