/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.history;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.HistoryDao;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.help.SummaryMode;
import dev.dsf.fhir.history.AtParameter;
import dev.dsf.fhir.history.History;
import dev.dsf.fhir.history.HistoryService;
import dev.dsf.fhir.history.SinceParameter;
import dev.dsf.fhir.history.filter.HistoryIdentityFilterFactory;
import dev.dsf.fhir.prefer.PreferHandlingType;
import dev.dsf.fhir.search.PageAndCount;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.service.ReferenceCleaner;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.springframework.beans.factory.InitializingBean;

public class HistoryServiceImpl
implements HistoryService,
InitializingBean {
    private final String serverBase;
    private final int defaultPageCount;
    private final ParameterConverter parameterConverter;
    private final ExceptionHandler exceptionHandler;
    private final ResponseGenerator responseGenerator;
    private final ReferenceCleaner referenceCleaner;
    private final HistoryDao historyDao;
    private final HistoryIdentityFilterFactory historyUserFilterFactory;

    public HistoryServiceImpl(String serverBase, int defaultPageCount, ParameterConverter parameterConverter, ExceptionHandler exceptionHandler, ResponseGenerator responseGenerator, ReferenceCleaner referenceCleaner, HistoryDao historyDao, HistoryIdentityFilterFactory historyUserFilterFactory) {
        this.serverBase = serverBase;
        this.defaultPageCount = defaultPageCount;
        this.parameterConverter = parameterConverter;
        this.exceptionHandler = exceptionHandler;
        this.responseGenerator = responseGenerator;
        this.referenceCleaner = referenceCleaner;
        this.historyDao = historyDao;
        this.historyUserFilterFactory = historyUserFilterFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.serverBase, "serverBase");
        Objects.requireNonNull(this.parameterConverter, "parameterConverter");
        Objects.requireNonNull(this.exceptionHandler, "exceptionHandler");
        Objects.requireNonNull(this.responseGenerator, "responseGenerator");
        Objects.requireNonNull(this.referenceCleaner, "referenceCleaner");
        Objects.requireNonNull(this.historyDao, "historyDao");
        Objects.requireNonNull(this.historyUserFilterFactory, "historyUserFilterFactory");
    }

    @Override
    public Bundle getHistory(Identity identity, UriInfo uri, HttpHeaders headers) {
        return this.getHistory(identity, uri, headers, null, null);
    }

    @Override
    public Bundle getHistory(Identity identity, UriInfo uri, HttpHeaders headers, Class<? extends Resource> resource) {
        return this.getHistory(identity, uri, headers, resource, null);
    }

    @Override
    public Bundle getHistory(Identity identity, UriInfo uri, HttpHeaders headers, Class<? extends Resource> resourceType, String id) {
        History history;
        MultivaluedMap queryParameters = uri.getQueryParameters();
        Integer page = this.parameterConverter.getFirstInt((Map<String, List<String>>)queryParameters, "_page");
        int effectivePage = page == null ? 1 : page;
        Integer count = this.parameterConverter.getFirstInt((Map<String, List<String>>)queryParameters, "_count");
        int effectiveCount = count == null || count < 0 ? this.defaultPageCount : count;
        PageAndCount pageAndCount = new PageAndCount(effectivePage, effectiveCount);
        ArrayList<AtParameter> atParameters = new ArrayList<AtParameter>();
        SinceParameter sinceParameter = new SinceParameter();
        ArrayList<SearchQueryParameterError> errors = new ArrayList<SearchQueryParameterError>();
        List atValues = (List)queryParameters.getOrDefault((Object)"_at", Collections.emptyList());
        atValues.stream().filter(v -> v != null && !v.isBlank()).forEach(atValue -> {
            AtParameter atParameter = new AtParameter();
            atParameters.add(atParameter);
            atParameter.configure((List<? super SearchQueryParameterError>)errors, "_at", (String)atValue);
        });
        String sinceValue = (String)queryParameters.getFirst((Object)"_since");
        if (sinceValue != null && !sinceValue.isBlank()) {
            sinceParameter.configure(errors, "_since", sinceValue);
        }
        String path = null;
        if (resourceType == null && id == null) {
            history = this.exceptionHandler.handleSqlException(() -> this.historyDao.readHistory(this.historyUserFilterFactory.getIdentityFilters(identity), pageAndCount, atParameters, sinceParameter));
        } else if (resourceType != null && id != null) {
            history = this.exceptionHandler.handleSqlException(() -> this.historyDao.readHistory(this.historyUserFilterFactory.getIdentityFilter(identity, resourceType), pageAndCount, atParameters, sinceParameter, resourceType, this.parameterConverter.toUuid(this.getResourceTypeName(resourceType), id)));
            path = resourceType.getAnnotation(ResourceDef.class).name();
        } else if (resourceType != null) {
            history = this.exceptionHandler.handleSqlException(() -> this.historyDao.readHistory(this.historyUserFilterFactory.getIdentityFilter(identity, resourceType), pageAndCount, atParameters, sinceParameter, resourceType));
            path = resourceType.getAnnotation(ResourceDef.class).name();
        } else {
            throw new WebApplicationException();
        }
        if (!errors.isEmpty() && PreferHandlingType.STRICT.equals((Object)this.parameterConverter.getPreferHandling(headers))) {
            throw new WebApplicationException(this.responseGenerator.response(Response.Status.BAD_REQUEST, (Resource)this.responseGenerator.toOperationOutcomeError(errors), this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build());
        }
        String format = (String)queryParameters.getFirst((Object)"_format");
        String pretty = (String)queryParameters.getFirst((Object)"_pretty");
        SummaryMode summaryMode = SummaryMode.fromString((String)queryParameters.getFirst((Object)"_summary"));
        UriBuilder bundleUri = UriBuilder.fromPath((String)this.serverBase);
        if (path != null) {
            bundleUri = bundleUri.path(path);
        }
        if (path != null && id != null) {
            bundleUri = bundleUri.path(id);
        }
        bundleUri = bundleUri.path("_history");
        bundleUri = this.configureBundleUri(bundleUri, atParameters, sinceParameter);
        Bundle bundle = this.responseGenerator.createHistoryBundle(history, errors, bundleUri, format, pretty, summaryMode);
        bundle.getEntry().stream().filter(Bundle.BundleEntryComponent::hasResource).map(Bundle.BundleEntryComponent::getResource).forEach(arg_0 -> ((ReferenceCleaner)this.referenceCleaner).cleanLiteralReferences(arg_0));
        return bundle;
    }

    private UriBuilder configureBundleUri(UriBuilder bundleUri, List<AtParameter> atParameters, SinceParameter sinceParameter) {
        Objects.requireNonNull(bundleUri, "bundleUri");
        Stream.concat(atParameters.stream(), Stream.of(sinceParameter)).filter(SearchQueryParameter::isDefined).forEach(p -> bundleUri.replaceQueryParam(p.getBundleUriQueryParameterName(), new Object[]{p.getBundleUriQueryParameterValue()}));
        return bundleUri;
    }

    private String getResourceTypeName(Class<? extends Resource> resource) {
        if (resource == null) {
            return null;
        }
        return resource.getAnnotation(ResourceDef.class).name();
    }
}

