/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.help;

import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.SummaryMode;
import dev.dsf.fhir.prefer.PreferHandlingType;
import dev.dsf.fhir.prefer.PreferReturnType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterConverter {
    private static final Logger logger = LoggerFactory.getLogger(ParameterConverter.class);
    public static final String HTML_FORMAT = "html";
    public static final String JSON_FORMAT = "json";
    public static final List<String> JSON_FORMATS = List.of("application/json+fhir", "application/fhir+json", "application/json");
    public static final String XML_FORMAT = "xml";
    public static final List<String> XML_FORMATS = List.of("application/xml+fhir", "application/fhir+xml", "application/xml", "text/xml");
    private final ExceptionHandler exceptionHandler;

    public ParameterConverter(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public UUID toUuid(String resourceTypeName, String id) {
        if (id == null) {
            return null;
        }
        return this.toUuid(id).orElseThrow(() -> this.exceptionHandler.notFound(resourceTypeName));
    }

    public Optional<UUID> toUuid(String id) {
        if (id == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(UUID.fromString(id));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public MediaType getMediaTypeThrowIfNotSupported(UriInfo uri, HttpHeaders headers) throws WebApplicationException {
        return this.getMediaTypeIfSupported(uri, headers).orElseThrow(() -> {
            logger.warn("Media type not supported");
            return new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        });
    }

    public Optional<MediaType> getMediaTypeIfSupported(UriInfo uri, HttpHeaders headers) {
        String format = (String)uri.getQueryParameters().getFirst((Object)"_format");
        boolean pretty = "true".equals(uri.getQueryParameters().getFirst((Object)"_pretty"));
        SummaryMode summaryMode = SummaryMode.fromString((String)uri.getQueryParameters().getFirst((Object)"_summary"));
        String accept = headers.getHeaderString("Accept");
        if (format == null || format.isBlank()) {
            return this.getMediaType(accept, pretty, summaryMode);
        }
        if (XML_FORMATS.contains(format) || JSON_FORMATS.contains(format) || "text/html".equals(format)) {
            return this.getMediaType(format, pretty, summaryMode);
        }
        if (XML_FORMAT.equals(format)) {
            return Optional.of(this.mediaType("application", "fhir+xml", pretty, summaryMode));
        }
        if (JSON_FORMAT.equals(format)) {
            return Optional.of(this.mediaType("application", "fhir+json", pretty, summaryMode));
        }
        if (HTML_FORMAT.equals(format)) {
            return Optional.of(this.mediaType("text", HTML_FORMAT, pretty, summaryMode));
        }
        return Optional.empty();
    }

    private Optional<MediaType> getMediaType(String mediaType, boolean pretty, SummaryMode summaryMode) {
        if (mediaType == null || mediaType.isBlank()) {
            mediaType = "*/*";
        }
        if (mediaType.contains("text/html")) {
            return Optional.of(this.mediaType("text", HTML_FORMAT, pretty, summaryMode));
        }
        if (mediaType.contains("application/fhir+json")) {
            return Optional.of(this.mediaType("application", "fhir+json", pretty, summaryMode));
        }
        if (mediaType.contains("application/json+fhir")) {
            return Optional.of(this.mediaType("application", "json+fhir", pretty, summaryMode));
        }
        if (mediaType.contains("application/json")) {
            return Optional.of(this.mediaType("application", JSON_FORMAT, pretty, summaryMode));
        }
        if (mediaType.contains("application/fhir+xml")) {
            return Optional.of(this.mediaType("application", "fhir+xml", pretty, summaryMode));
        }
        if (mediaType.contains("application/xml+fhir")) {
            return Optional.of(this.mediaType("application", "xml+fhir", pretty, summaryMode));
        }
        if (mediaType.contains("application/xml")) {
            return Optional.of(this.mediaType("application", XML_FORMAT, pretty, summaryMode));
        }
        if (mediaType.contains("text/xml")) {
            return Optional.of(this.mediaType("text", XML_FORMAT, pretty, summaryMode));
        }
        if (mediaType.contains("*/*")) {
            return Optional.of(this.mediaType("application", "fhir+xml", pretty, summaryMode));
        }
        return Optional.empty();
    }

    private MediaType mediaType(String type, String subtype, boolean pretty, SummaryMode summaryMode) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (pretty) {
            parameters.put("pretty", "true");
        }
        if (summaryMode != null) {
            parameters.put("summary", summaryMode.toString());
        }
        return new MediaType(type, subtype, parameters);
    }

    public PreferReturnType getPreferReturn(HttpHeaders headers) {
        List preferHeaders = headers.getRequestHeader("Prefer");
        if (preferHeaders == null) {
            return PreferReturnType.REPRESENTATION;
        }
        return preferHeaders.stream().map(PreferReturnType::fromString).findFirst().orElse(PreferReturnType.REPRESENTATION);
    }

    public PreferHandlingType getPreferHandling(HttpHeaders headers) {
        List preferHeaders = headers.getRequestHeader("Prefer");
        if (preferHeaders == null) {
            return PreferHandlingType.LENIENT;
        }
        return preferHeaders.stream().map(PreferHandlingType::fromString).findFirst().orElse(PreferHandlingType.LENIENT);
    }

    public Integer getFirstInt(Map<String, List<String>> queryParameters, String key) {
        List listForKey = queryParameters.getOrDefault(key, Collections.emptyList());
        if (listForKey.isEmpty()) {
            return null;
        }
        try {
            return Integer.valueOf((String)listForKey.get(0));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Map<String, List<String>> urlDecodeQueryParameters(Map<String, List<String>> queryParameters) {
        LinkedHashMap<String, List<String>> cleaned = new LinkedHashMap<String, List<String>>((int)((double)queryParameters.size() / 0.75) + 1);
        for (Map.Entry<String, List<String>> entry : queryParameters.entrySet()) {
            cleaned.put(entry.getKey(), this.urlDecodeQueryParameter(entry.getValue()));
        }
        return cleaned;
    }

    private List<String> urlDecodeQueryParameter(List<String> queryParameterValues) {
        return queryParameterValues.stream().map(v -> URLDecoder.decode(v, StandardCharsets.UTF_8)).collect(Collectors.toList());
    }

    public Optional<EntityTag> toEntityTag(String eTagValue) {
        if (eTagValue == null || eTagValue.isBlank()) {
            return Optional.empty();
        }
        try {
            EntityTag eTag = (EntityTag)RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class).fromString(eTagValue);
            if (eTag.isWeak()) {
                return Optional.of(eTag);
            }
            logger.warn("{} not a weak ETag", (Object)eTag.getValue());
            return Optional.empty();
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unable to parse ETag value", (Throwable)e);
            logger.warn("Unable to parse ETag value: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public Optional<Long> toVersion(EntityTag tag) {
        if (tag == null || tag.getValue() == null || tag.getValue().isBlank()) {
            return Optional.empty();
        }
        return this.toVersion(tag.getValue());
    }

    public Optional<Long> toVersion(String version) {
        if (version == null || version.isBlank()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Long.parseLong(version));
        }
        catch (NumberFormatException e) {
            logger.debug("Version not a Long value", (Throwable)e);
            logger.warn("Version not a Long value: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return Optional.empty();
        }
    }
}

