/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.function;

import java.sql.SQLException;
import java.util.Objects;

@FunctionalInterface
public interface BiConsumerWithSqlException<T, U> {
    public void accept(T var1, U var2) throws SQLException;

    default public BiConsumerWithSqlException<T, U> andThen(BiConsumerWithSqlException<? super T, ? super U> after) {
        Objects.requireNonNull(after);
        return (t, u) -> {
            SQLException suppressed = null;
            try {
                this.accept(t, u);
            }
            catch (SQLException e) {
                suppressed = e;
            }
            finally {
                try {
                    after.accept(t, u);
                }
                catch (SQLException e) {
                    if (suppressed != null) {
                        e.addSuppressed(suppressed);
                    }
                    throw e;
                }
            }
        };
    }
}

