/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.jdbc;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.fhir.dao.BinaryDao;
import dev.dsf.fhir.dao.jdbc.AbstractResourceDaoJdbc;
import dev.dsf.fhir.dao.jdbc.PreparedStatementFactoryBinary;
import dev.dsf.fhir.search.filter.BinaryIdentityFilter;
import dev.dsf.fhir.search.parameters.BinaryContentType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.IdType;
import org.postgresql.util.PGobject;

public class BinaryDaoJdbc
extends AbstractResourceDaoJdbc<Binary>
implements BinaryDao {
    public BinaryDaoJdbc(DataSource dataSource, DataSource permanentDeleteDataSource, FhirContext fhirContext) {
        super(dataSource, permanentDeleteDataSource, Binary.class, "binaries", "binary_json", "binary_id", new PreparedStatementFactoryBinary(fhirContext), BinaryIdentityFilter::new, List.of(BinaryDaoJdbc.factory("contentType", BinaryContentType::new, BinaryContentType.getNameModifiers())), List.of());
    }

    @Override
    protected Binary copy(Binary resource) {
        return resource.copy();
    }

    @Override
    protected Binary getResource(ResultSet result, int index) throws SQLException {
        Binary binary = (Binary)super.getResource(result, index);
        IdType fixedId = new IdType(binary.getResourceType().name(), binary.getIdElement().getIdPart(), binary.getMeta().getVersionId());
        binary.setIdElement(fixedId);
        return binary;
    }

    @Override
    protected void modifySearchResultResource(Binary resource, Connection connection) throws SQLException {
        block13: {
            try (PreparedStatement statement = connection.prepareStatement("SELECT binary_data FROM binaries WHERE binary_id = ? AND version = ?");){
                PGobject uuidObject = this.getPreparedStatementFactory().uuidToPgObject(this.toUuid(resource.getIdElement().getIdPart()));
                Long version = resource.getMeta().getVersionIdElement().getIdPartAsLong();
                statement.setObject(1, uuidObject);
                statement.setLong(2, version);
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        byte[] data = result.getBytes(1);
                        resource.setData(data);
                        break block13;
                    }
                    throw new SQLException("Binary resource with id " + resource.getIdElement().getIdPart() + " not found");
                }
            }
        }
    }
}

