/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.jdbc;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.fhir.dao.ActivityDefinitionDao;
import dev.dsf.fhir.dao.jdbc.AbstractResourceDaoJdbc;
import dev.dsf.fhir.dao.jdbc.ReadByUrlDaoJdbc;
import dev.dsf.fhir.search.filter.ActivityDefinitionIdentityFilter;
import dev.dsf.fhir.search.parameters.ActivityDefinitionDate;
import dev.dsf.fhir.search.parameters.ActivityDefinitionIdentifier;
import dev.dsf.fhir.search.parameters.ActivityDefinitionName;
import dev.dsf.fhir.search.parameters.ActivityDefinitionStatus;
import dev.dsf.fhir.search.parameters.ActivityDefinitionUrl;
import dev.dsf.fhir.search.parameters.ActivityDefinitionVersion;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityDefinitionDaoJdbc
extends AbstractResourceDaoJdbc<ActivityDefinition>
implements ActivityDefinitionDao {
    private static final Logger logger = LoggerFactory.getLogger(ActivityDefinitionDaoJdbc.class);
    private final ReadByUrlDaoJdbc<ActivityDefinition> readByUrl = new ReadByUrlDaoJdbc<ActivityDefinition>(this::getDataSource, this::getResource, this.getResourceTable(), this.getResourceColumn());

    public ActivityDefinitionDaoJdbc(DataSource dataSource, DataSource permanentDeleteDataSource, FhirContext fhirContext) {
        super(dataSource, permanentDeleteDataSource, fhirContext, ActivityDefinition.class, "activity_definitions", "activity_definition", "activity_definition_id", ActivityDefinitionIdentityFilter::new, List.of(ActivityDefinitionDaoJdbc.factory("date", ActivityDefinitionDate::new), ActivityDefinitionDaoJdbc.factory("identifier", ActivityDefinitionIdentifier::new), ActivityDefinitionDaoJdbc.factory("name", ActivityDefinitionName::new, ActivityDefinitionName.getNameModifiers()), ActivityDefinitionDaoJdbc.factory("status", ActivityDefinitionStatus::new, ActivityDefinitionStatus.getNameModifiers()), ActivityDefinitionDaoJdbc.factory("url", ActivityDefinitionUrl::new), ActivityDefinitionDaoJdbc.factory("version", ActivityDefinitionVersion::new, ActivityDefinitionVersion.getNameModifiers())), List.of());
    }

    @Override
    protected ActivityDefinition copy(ActivityDefinition resource) {
        return resource.copy();
    }

    @Override
    public Optional<ActivityDefinition> readByUrlAndVersion(String urlAndVersion) throws SQLException {
        return this.readByUrl.readByUrlAndVersion(urlAndVersion);
    }

    @Override
    public Optional<ActivityDefinition> readByUrlAndVersionWithTransaction(Connection connection, String urlAndVersion) throws SQLException {
        return this.readByUrl.readByUrlAndVersionWithTransaction(connection, urlAndVersion);
    }

    @Override
    public Optional<ActivityDefinition> readByUrlAndVersion(String url, String version) throws SQLException {
        return this.readByUrl.readByUrlAndVersion(url, version);
    }

    @Override
    public Optional<ActivityDefinition> readByUrlAndVersionWithTransaction(Connection connection, String url, String version) throws SQLException {
        return this.readByUrl.readByUrlAndVersionWithTransaction(connection, url, version);
    }

    @Override
    public Optional<ActivityDefinition> readByProcessUrlVersionAndStatusDraftOrActiveWithTransaction(Connection connection, String processUrl, String processVersion) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(processUrl, "processUrl");
        if (processUrl.isBlank()) {
            throw new IllegalArgumentException("processUrl blank");
        }
        Objects.requireNonNull(processVersion, "processVersion");
        if (processVersion.isBlank()) {
            throw new IllegalArgumentException("processVersion blank");
        }
        try (PreparedStatement statement = connection.prepareStatement("SELECT activity_definition FROM current_activity_definitions WHERE activity_definition->>'url' = ? AND activity_definition->>'version' = ? AND (lower(activity_definition->>'status') = 'draft' OR lower(activity_definition->>'status') = 'active')");){
            Optional<ActivityDefinition> optional;
            block19: {
                ArrayList<ActivityDefinition> definitions;
                ResultSet result;
                block17: {
                    Optional<ActivityDefinition> optional2;
                    block18: {
                        statement.setString(1, processUrl);
                        statement.setString(2, processVersion);
                        logger.trace("Executing query '{}'", (Object)statement);
                        result = statement.executeQuery();
                        try {
                            definitions = new ArrayList<ActivityDefinition>();
                            if (result.next()) {
                                definitions.add((ActivityDefinition)this.getResource(result, 1));
                            }
                            if (definitions.size() == 1) break block17;
                            logger.warn("ActivityDefinition with process-url '{}' and process-version '{}' not found, or more than one", (Object)processUrl, (Object)processVersion);
                            optional2 = Optional.empty();
                            if (result == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return optional2;
                }
                optional = Optional.of((ActivityDefinition)definitions.get(0));
                if (result == null) break block19;
                result.close();
            }
            return optional;
        }
    }
}

