/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import ca.uhn.fhir.validation.ValidationResult;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.command.AbstractCommandWithResource;
import dev.dsf.fhir.dao.command.AuthorizationHelper;
import dev.dsf.fhir.dao.command.ModifyingCommand;
import dev.dsf.fhir.dao.command.ValidationHelper;
import dev.dsf.fhir.dao.exception.ResourceDeletedException;
import dev.dsf.fhir.dao.exception.ResourceNotFoundException;
import dev.dsf.fhir.dao.exception.ResourceVersionNoMatchException;
import dev.dsf.fhir.event.EventGenerator;
import dev.dsf.fhir.event.EventHandler;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.prefer.PreferReturnType;
import dev.dsf.fhir.search.PartialResult;
import dev.dsf.fhir.search.SearchQuery;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.validation.SnapshotGenerator;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class UpdateCommand<R extends Resource, D extends ResourceDao<R>>
extends AbstractCommandWithResource<R, D>
implements ModifyingCommand {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCommand.class);
    protected final ResponseGenerator responseGenerator;
    protected final ReferenceCleaner referenceCleaner;
    protected final EventGenerator eventGenerator;
    protected R updatedResource;
    protected ValidationResult validationResult;

    public UpdateCommand(int index, Identity identity, PreferReturnType returnType, Bundle bundle, Bundle.BundleEntryComponent entry, String serverBase, AuthorizationHelper authorizationHelper, R resource, D dao, ExceptionHandler exceptionHandler, ParameterConverter parameterConverter, ResponseGenerator responseGenerator, ReferenceExtractor referenceExtractor, ReferenceResolver referenceResolver, ReferenceCleaner referenceCleaner, EventGenerator eventGenerator) {
        super(3, index, identity, returnType, bundle, entry, serverBase, authorizationHelper, resource, dao, exceptionHandler, parameterConverter, responseGenerator, referenceExtractor, referenceResolver);
        this.responseGenerator = responseGenerator;
        this.referenceCleaner = referenceCleaner;
        this.eventGenerator = eventGenerator;
    }

    @Override
    public void preExecute(Map<String, IdType> idTranslationTable, Connection connection, ValidationHelper validationHelper, SnapshotGenerator snapshotGenerator) {
        UriComponents eruComponentes = UriComponentsBuilder.fromUriString((String)this.entry.getRequest().getUrl()).build();
        if (eruComponentes.getPathSegments().size() == 2 && eruComponentes.getQueryParams().isEmpty()) {
            String expectedId;
            if (!this.entry.hasFullUrl() || this.entry.getFullUrl().startsWith("urn:uuid:")) {
                throw new WebApplicationException(this.responseGenerator.badUpdateRequestUrl(this.index, this.entry.getRequest().getUrl()));
            }
            if (!this.resource.hasIdElement() || !this.resource.getIdElement().hasIdPart()) {
                throw new WebApplicationException(this.responseGenerator.bundleEntryResouceMissingId(this.index, this.resource.getResourceType().name()));
            }
            if (this.resource.getIdElement().getIdPart().startsWith("urn:uuid:")) {
                throw new WebApplicationException(this.responseGenerator.badUpdateRequestUrl(this.index, this.entry.getRequest().getUrl()));
            }
            String expectedBaseUrl = this.serverBase;
            String expectedResourceTypeName = this.resource.getResourceType().name();
            String expectedfullUrl = new IdType(expectedBaseUrl, expectedResourceTypeName, expectedId = this.resource.getIdElement().getIdPart(), null).getValue();
            if (!expectedfullUrl.equals(this.entry.getFullUrl())) {
                throw new WebApplicationException(this.responseGenerator.badBundleEntryFullUrl(this.index, this.entry.getFullUrl()));
            }
            if (!expectedResourceTypeName.equals(eruComponentes.getPathSegments().get(0)) || !expectedId.equals(eruComponentes.getPathSegments().get(1))) {
                throw new WebApplicationException(this.responseGenerator.badUpdateRequestUrl(this.index, this.entry.getRequest().getUrl()));
            }
        } else if (eruComponentes.getPathSegments().size() == 1 && !eruComponentes.getQueryParams().isEmpty()) {
            if (!this.entry.getFullUrl().startsWith("urn:uuid:")) {
                throw new WebApplicationException(this.responseGenerator.badUpdateRequestUrl(this.index, this.entry.getRequest().getUrl()));
            }
            if (this.resource.hasIdElement() && !this.resource.getIdElement().getValue().startsWith("urn:uuid:")) {
                throw new WebApplicationException(this.responseGenerator.bundleEntryBadResourceId(this.index, this.resource.getResourceType().name(), "urn:uuid:"));
            }
            if (this.resource.hasIdElement() && !this.entry.getFullUrl().equals(this.resource.getIdElement().getValue())) {
                throw new WebApplicationException(this.responseGenerator.badBundleEntryFullUrlVsResourceId(this.index, this.entry.getFullUrl(), this.resource.getIdElement().getValue()));
            }
            this.addMissingIdToTranslationTableAndCheckConditionFindsResource(idTranslationTable, connection);
        } else {
            throw new WebApplicationException(this.responseGenerator.badUpdateRequestUrl(this.index, this.entry.getRequest().getUrl()));
        }
    }

    private boolean addMissingIdToTranslationTableAndCheckConditionFindsResource(Map<String, IdType> idTranslationTable, Connection connection) {
        UriComponents componentes = UriComponentsBuilder.fromUriString((String)this.entry.getRequest().getUrl()).build();
        String resourceTypeName = (String)componentes.getPathSegments().get(0);
        Map<String, List<String>> queryParameters = this.parameterConverter.urlDecodeQueryParameters((Map<String, List<String>>)componentes.getQueryParams());
        if (Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(queryParameters::containsKey)) {
            logger.warn("Query contains parameter not applicable in this conditional update context: '{}', parameters {} will be ignored", (Object)UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap(queryParameters)).toUriString(), (Object)Arrays.toString(SearchQuery.STANDARD_PARAMETERS));
            queryParameters = queryParameters.entrySet().stream().filter(e -> !Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(p -> p.equals(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        SearchQuery query = this.dao.createSearchQueryWithoutUserFilter(1, 1);
        query.configureParameters(queryParameters);
        List<SearchQueryParameterError> unsupportedParams = query.getUnsupportedQueryParameters();
        if (!unsupportedParams.isEmpty()) {
            throw new WebApplicationException(this.responseGenerator.unsupportedConditionalUpdateQuery(this.index, this.entry.getRequest().getUrl(), unsupportedParams));
        }
        PartialResult result = this.exceptionHandler.handleSqlException(() -> this.dao.searchWithTransaction(connection, query));
        if (result.getTotal() <= 0 && (!this.resource.hasId() || this.resource.getIdElement().getValue().startsWith("urn:uuid:"))) {
            if (!idTranslationTable.containsKey(this.entry.getFullUrl())) {
                UUID id = UUID.randomUUID();
                idTranslationTable.put(this.entry.getFullUrl(), new IdType(this.resource.getResourceType().toString(), id.toString()));
            }
            return false;
        }
        if (result.getTotal() <= 0 && this.resource.hasId()) {
            throw new WebApplicationException(this.responseGenerator.updateAsCreateNotAllowed(resourceTypeName));
        }
        if (result.getTotal() == 1) {
            Resource dbResource = (Resource)result.getPartialResult().get(0);
            IdType dbResourceId = dbResource.getIdElement();
            if (!this.resource.hasId() || this.resource.getIdElement().getValue().startsWith("urn:uuid:")) {
                idTranslationTable.put(this.entry.getFullUrl(), new IdType(this.resource.getResourceType().toString(), dbResource.getIdElement().getIdPart()));
                return true;
            }
            if (this.resource.hasId() && (!this.resource.getIdElement().hasBaseUrl() || this.serverBase.equals(this.resource.getIdElement().getBaseUrl())) && (!this.resource.getIdElement().hasResourceType() || resourceTypeName.equals(this.resource.getIdElement().getResourceType())) && dbResourceId.getIdPart().equals(this.resource.getIdElement().getIdPart())) {
                idTranslationTable.put(this.entry.getFullUrl(), new IdType(this.resource.getResourceType().toString(), dbResource.getIdElement().getIdPart()));
                return true;
            }
            throw new WebApplicationException(this.responseGenerator.badRequestIdsNotMatching(dbResourceId.withServerBase(this.serverBase, resourceTypeName), this.resource.getIdElement().hasBaseUrl() && this.resource.getIdElement().hasResourceType() ? this.resource.getIdElement() : this.resource.getIdElement().withServerBase(this.serverBase, resourceTypeName)));
        }
        throw new WebApplicationException(this.responseGenerator.multipleExists(resourceTypeName, UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap(queryParameters)).toUriString()));
    }

    @Override
    public void execute(Map<String, IdType> idTranslationTable, Connection connection, ValidationHelper validationHelper, SnapshotGenerator snapshotGenerator) throws SQLException, WebApplicationException {
        UriComponents componentes = UriComponentsBuilder.fromUriString((String)this.entry.getRequest().getUrl()).build();
        if (componentes.getPathSegments().size() == 2 && componentes.getQueryParams().isEmpty()) {
            this.updateById(idTranslationTable, connection, validationHelper, (String)componentes.getPathSegments().get(0), (String)componentes.getPathSegments().get(1));
        } else if (componentes.getPathSegments().size() == 1 && !componentes.getQueryParams().isEmpty()) {
            this.updateByCondition(idTranslationTable, connection, validationHelper, (String)componentes.getPathSegments().get(0));
        } else {
            throw new WebApplicationException(this.responseGenerator.badUpdateRequestUrl(this.index, this.entry.getRequest().getUrl()));
        }
    }

    private void updateById(Map<String, IdType> idTranslationTable, Connection connection, ValidationHelper validationHelper, String resourceTypeName, String pathId) throws SQLException {
        IdType resourceId = this.resource.getIdElement();
        if (!Objects.equals(pathId, resourceId.getIdPart())) {
            throw new WebApplicationException(this.responseGenerator.pathVsElementIdInBundle(this.index, resourceTypeName, pathId, resourceId));
        }
        if (resourceId.getBaseUrl() != null && !this.serverBase.equals(resourceId.getBaseUrl())) {
            throw new WebApplicationException(this.responseGenerator.invalidBaseUrlInBundle(this.index, resourceTypeName, resourceId));
        }
        if (!Objects.equals(resourceTypeName, this.resource.getResourceType().name())) {
            throw new WebApplicationException(this.responseGenerator.nonMatchingResourceTypeAndRequestUrlInBundle(this.index, resourceTypeName, this.entry.getRequest().getUrl()));
        }
        Resource copy = this.resource.copy();
        this.checkUpdateAllowed(idTranslationTable, connection, validationHelper, this.identity, copy);
        Optional ifMatch = Optional.ofNullable(this.entry.getRequest().getIfMatch()).flatMap(this.parameterConverter::toEntityTag).flatMap(this.parameterConverter::toVersion);
        this.updatedResource = this.exceptionHandler.handleSqlExAndResourceNotFoundExAndResouceVersionNonMatchEx(resourceTypeName, () -> this.updateWithTransaction(connection, this.resource, ifMatch.orElse(null)));
    }

    protected R updateWithTransaction(Connection connection, R resource, Long expectedVersion) throws SQLException, ResourceNotFoundException, ResourceVersionNoMatchException {
        return this.dao.updateWithTransaction(connection, resource, expectedVersion);
    }

    private void checkUpdateAllowed(Map<String, IdType> idTranslationTable, Connection connection, ValidationHelper validationHelper, Identity identity, R newResource) {
        String id;
        String resourceTypeName = newResource.getResourceType().name();
        Optional dbResource = this.exceptionHandler.handleSqlAndResourceDeletedException(this.serverBase, resourceTypeName, () -> this.lambda$checkUpdateAllowed$4(connection, resourceTypeName, id = newResource.getIdElement().getIdPart()));
        if (dbResource.isEmpty()) {
            audit.info("Update as create of non existing {} denied for identity '{}'", (Object)resourceTypeName, (Object)identity.getName());
            throw new WebApplicationException(this.responseGenerator.updateAsCreateNotAllowed(resourceTypeName));
        }
        this.referencesHelper.resolveTemporaryAndConditionalReferencesOrLiteralInternalRelatedArtifactOrAttachmentUrls(idTranslationTable, connection);
        this.validationResult = validationHelper.checkResourceValidForUpdate(identity, this.resource);
        this.referencesHelper.resolveLogicalReferences(connection);
        this.authorizationHelper.checkUpdateAllowed(this.index, connection, identity, (Resource)dbResource.get(), this.resource);
    }

    private void updateByCondition(Map<String, IdType> idTranslationTable, Connection connection, ValidationHelper validationHelper, String resourceTypeName) throws SQLException {
        boolean foundByCondition = this.addMissingIdToTranslationTableAndCheckConditionFindsResource(idTranslationTable, connection);
        if (foundByCondition) {
            this.resource.setIdElement(this.getId(idTranslationTable));
            this.updateById(idTranslationTable, connection, validationHelper, resourceTypeName, this.resource.getIdElement().getIdPart());
        } else {
            this.referencesHelper.resolveTemporaryAndConditionalReferencesOrLiteralInternalRelatedArtifactOrAttachmentUrls(idTranslationTable, connection);
            this.validationResult = validationHelper.checkResourceValidForCreate(this.identity, this.resource);
            this.referencesHelper.resolveLogicalReferences(connection);
            this.authorizationHelper.checkCreateAllowed(this.index, connection, this.identity, this.resource);
            this.updatedResource = this.createWithTransactionAndId(connection, this.resource, this.getUuid(idTranslationTable));
        }
    }

    protected R createWithTransactionAndId(Connection connection, R resource, UUID uuid) throws SQLException {
        return this.dao.createWithTransactionAndId(connection, resource, uuid);
    }

    private IdType getId(Map<String, IdType> idTranslationTable) {
        IdType idType = idTranslationTable.get(this.entry.getFullUrl());
        if (idType != null) {
            return idType;
        }
        throw new RuntimeException("Error while retrieving id from id translation table");
    }

    private UUID getUuid(Map<String, IdType> idTranslationTable) {
        Optional<UUID> uuid = this.parameterConverter.toUuid(this.getId(idTranslationTable).getIdPart());
        if (uuid.isPresent()) {
            return uuid.get();
        }
        throw new RuntimeException("Error while retrieving id from id translation table");
    }

    @Override
    public Optional<Bundle.BundleEntryComponent> postExecute(Connection connection, EventHandler eventHandler) {
        R updatedResourceWithResolvedReferences = this.latestOrErrorIfDeletedOrNotFound(connection, (Resource)this.updatedResource);
        try {
            this.referenceCleaner.cleanLiteralReferences(updatedResourceWithResolvedReferences);
            eventHandler.handleEvent(this.eventGenerator.newResourceUpdatedEvent((Resource)updatedResourceWithResolvedReferences));
        }
        catch (Exception e) {
            logger.debug("Error while handling resource updated event", (Throwable)e);
            logger.warn("Error while handling resource updated event: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
        IdType location = updatedResourceWithResolvedReferences.getIdElement().withServerBase(this.serverBase, updatedResourceWithResolvedReferences.getResourceType().name());
        Bundle.BundleEntryComponent resultEntry = new Bundle.BundleEntryComponent();
        resultEntry.setFullUrl(location.toVersionless().toString());
        if (PreferReturnType.REPRESENTATION.equals((Object)this.returnType)) {
            resultEntry.setResource(updatedResourceWithResolvedReferences);
        } else if (PreferReturnType.OPERATION_OUTCOME.equals((Object)this.returnType)) {
            OperationOutcome outcome = this.responseGenerator.updated(location.toString(), (Resource)updatedResourceWithResolvedReferences);
            this.validationResult.populateOperationOutcome((IBaseOperationOutcome)outcome);
            resultEntry.getResponse().setOutcome((Resource)outcome);
        }
        Bundle.BundleEntryResponseComponent response = resultEntry.getResponse();
        response.setStatus(Response.Status.OK.getStatusCode() + " " + Response.Status.OK.getReasonPhrase());
        response.setLocation(location.getValue());
        response.setEtag(RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class).toString((Object)new EntityTag(updatedResourceWithResolvedReferences.getMeta().getVersionId(), true)));
        response.setLastModified(updatedResourceWithResolvedReferences.getMeta().getLastUpdated());
        return Optional.of(resultEntry);
    }

    private R latestOrErrorIfDeletedOrNotFound(Connection connection, Resource resource) {
        try {
            return (R)((Resource)this.dao.readWithTransaction(connection, this.parameterConverter.toUuid(resource.getResourceType().name(), resource.getIdElement().getIdPart())).orElseThrow(() -> new ResourceNotFoundException(resource.getIdElement().getIdPart())));
        }
        catch (ResourceDeletedException | ResourceNotFoundException | SQLException e) {
            logger.debug("Error while reading resource from db", (Throwable)e);
            logger.warn("Error while reading resource from db: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ Optional lambda$checkUpdateAllowed$4(Connection connection, String resourceTypeName, String id) throws SQLException, ResourceDeletedException {
        return this.dao.readWithTransaction(connection, this.parameterConverter.toUuid(resourceTypeName, id));
    }
}

