/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import dev.dsf.fhir.dao.command.AbstractCommandList;
import dev.dsf.fhir.dao.command.Command;
import dev.dsf.fhir.dao.command.CommandList;
import dev.dsf.fhir.dao.command.TransactionEventHandler;
import dev.dsf.fhir.dao.command.TransactionResources;
import dev.dsf.fhir.dao.command.ValidationHelper;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.validation.SnapshotGenerator;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.sql.Connection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.sql.DataSource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCommandList
extends AbstractCommandList
implements CommandList {
    private static final Logger logger = LoggerFactory.getLogger(TransactionCommandList.class);
    private final Function<Connection, TransactionResources> transactionResourceFactory;

    public TransactionCommandList(DataSource dataSource, ExceptionHandler exceptionHandler, List<? extends Command> commands, Function<Connection, TransactionResources> transactionResourceFactory) {
        super(dataSource, exceptionHandler, commands);
        this.transactionResourceFactory = transactionResourceFactory;
        Collections.sort(this.commands, Comparator.comparing(Command::getTransactionPriority).thenComparing(Command::getIndex));
    }

    @Override
    public Bundle execute() throws WebApplicationException {
        HashMap results = new HashMap((int)((double)this.commands.size() / 0.75) + 1);
        try {
            TransactionEventHandler transactionEventHandler;
            try (Connection connection = this.dataSource.getConnection();){
                if (this.hasModifyingCommands) {
                    connection.setReadOnly(false);
                    connection.setAutoCommit(false);
                    connection.setTransactionIsolation(4);
                }
                TransactionResources transactionResources = this.transactionResourceFactory.apply(connection);
                transactionEventHandler = transactionResources.getTransactionEventHandler();
                ValidationHelper validationHelper = transactionResources.getValidationHelper();
                SnapshotGenerator snapshotGenerator = transactionResources.getSnapshotGenerator();
                HashMap<String, IdType> idTranslationTable = new HashMap<String, IdType>();
                for (Command c : this.commands) {
                    try {
                        logger.debug("Running pre-execute of command {} for entry at index {}", (Object)c.getClass().getName(), (Object)c.getIndex());
                        c.preExecute(idTranslationTable, connection, validationHelper, snapshotGenerator);
                    }
                    catch (Exception e2) {
                        logger.debug("Error while running pre-execute of command {} for entry at index {}, abborting transaction", new Object[]{c.getClass().getSimpleName(), c.getIndex(), e2});
                        logger.warn("Error while running pre-execute of command {} for entry at index {}, abborting transaction: {} - {}", new Object[]{c.getClass().getSimpleName(), c.getIndex(), e2.getClass().getName(), e2.getMessage()});
                        try {
                            this.commands.stream().limit(c.getIndex()).forEach(this::auditLogAbbort);
                            this.auditLogResult(c, this.toEntry(e2));
                        }
                        catch (Exception e1) {
                            logger.debug("Error while writing to audit log", (Throwable)e1);
                            logger.warn("Error while writing to audit log: {} - {}", (Object)e1.getClass().getName(), (Object)e1.getMessage());
                        }
                        throw e2;
                    }
                }
                for (Command c : this.commands) {
                    try {
                        logger.debug("Running execute of command {} for entry at index {}", (Object)c.getClass().getName(), (Object)c.getIndex());
                        c.execute(idTranslationTable, connection, validationHelper, snapshotGenerator);
                    }
                    catch (Exception e3) {
                        logger.debug("Error while executing command {} for entry at index {}, rolling back transaction", new Object[]{c.getClass().getSimpleName(), c.getIndex(), e3});
                        logger.warn("Error while executing command {} for entry at index {}, rolling back transaction: {} - {}", new Object[]{c.getClass().getSimpleName(), c.getIndex(), e3.getClass().getName(), e3.getMessage()});
                        if (this.hasModifyingCommands) {
                            logger.debug("Rolling back DB transaction");
                            connection.rollback();
                        }
                        try {
                            this.commands.stream().limit(c.getIndex()).forEach(this::auditLogAbbort);
                            this.auditLogResult(c, this.toEntry(e3));
                        }
                        catch (Exception e1) {
                            logger.debug("Error while writing to audit log", (Throwable)e1);
                            logger.warn("Error while writing to audit log: {} - {}", (Object)e1.getClass().getName(), (Object)e1.getMessage());
                        }
                        throw e3;
                    }
                }
                for (Command c : this.commands) {
                    try {
                        logger.debug("Running post-execute of command {} for entry at index {}", (Object)c.getClass().getName(), (Object)c.getIndex());
                        Optional<Bundle.BundleEntryComponent> optResult = c.postExecute(connection, transactionEventHandler);
                        optResult.ifPresent(result -> results.putIfAbsent(c.getIndex(), result));
                    }
                    catch (Exception e4) {
                        logger.debug("Error while running post-execute of command {} for entry at index {}, rolling back transaction", new Object[]{c.getClass().getSimpleName(), c.getIndex(), e4});
                        logger.warn("Error while running post-execute of command {} for entry at index {}, rolling back transaction: {} - {}", new Object[]{c.getClass().getSimpleName(), c.getIndex(), e4.getClass().getName(), e4.getMessage()});
                        if (this.hasModifyingCommands) {
                            logger.debug("Rolling back DB transaction");
                            connection.rollback();
                        }
                        try {
                            this.commands.stream().limit(c.getIndex()).forEach(this::auditLogAbbort);
                            this.auditLogResult(c, this.toEntry(e4));
                        }
                        catch (Exception e1) {
                            logger.debug("Error while writing to audit log", (Throwable)e1);
                            logger.warn("Error while writing to audit log: {} - {}", (Object)e1.getClass().getName(), (Object)e1.getMessage());
                        }
                        throw e4;
                    }
                }
                if (this.hasModifyingCommands) {
                    logger.debug("Committing DB transaction");
                    connection.commit();
                }
            }
            try {
                logger.debug("Committing events");
                transactionEventHandler.commitEvents();
            }
            catch (Exception e5) {
                logger.debug("Error while handling events", (Throwable)e5);
                logger.warn("Error while handling events: {} - {}", (Object)e5.getClass().getName(), (Object)e5.getMessage());
            }
            try {
                results.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(e -> {
                    Command command = (Command)this.commands.get((Integer)e.getKey());
                    Bundle.BundleEntryComponent result = (Bundle.BundleEntryComponent)e.getValue();
                    this.auditLogResult(command, result);
                });
            }
            catch (Exception e6) {
                logger.debug("Error while writing to audit log", (Throwable)e6);
                logger.warn("Error while writing to audit log: {} - {}", (Object)e6.getClass().getName(), (Object)e6.getMessage());
            }
            Bundle result2 = new Bundle();
            result2.setType(Bundle.BundleType.TRANSACTIONRESPONSE);
            results.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).forEach(arg_0 -> ((Bundle)result2).addEntry(arg_0));
            return result2;
        }
        catch (WebApplicationException e7) {
            if (e7.getResponse() != null && Response.Status.FORBIDDEN.getStatusCode() == e7.getResponse().getStatus()) {
                throw e7;
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(e7.getResponse().getEntity()).build());
        }
        catch (Exception e8) {
            throw this.exceptionHandler.internalServerErrorBundleTransaction(e8);
        }
    }
}

