/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.command.AbstractCommand;
import dev.dsf.fhir.dao.command.AuthorizationHelper;
import dev.dsf.fhir.dao.command.ModifyingCommand;
import dev.dsf.fhir.dao.command.ValidationHelper;
import dev.dsf.fhir.dao.exception.ResourceNotFoundException;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.event.EventGenerator;
import dev.dsf.fhir.event.EventHandler;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.prefer.PreferReturnType;
import dev.dsf.fhir.search.PartialResult;
import dev.dsf.fhir.search.SearchQuery;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.validation.SnapshotGenerator;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class DeleteCommand
extends AbstractCommand
implements ModifyingCommand {
    private static final Logger logger = LoggerFactory.getLogger(DeleteCommand.class);
    private final ResponseGenerator responseGenerator;
    private final DaoProvider daoProvider;
    private final ExceptionHandler exceptionHandler;
    private final ParameterConverter parameterConverter;
    private final EventGenerator eventGenerator;
    private boolean deleted;
    private String resourceTypeName;
    private Class<? extends Resource> resourceType;
    private String id;

    public DeleteCommand(int index, Identity identity, PreferReturnType returnType, Bundle bundle, Bundle.BundleEntryComponent entry, String serverBase, AuthorizationHelper authorizationHelper, ResponseGenerator responseGenerator, DaoProvider daoProvider, ExceptionHandler exceptionHandler, ParameterConverter parameterConverter, EventGenerator eventGenerator) {
        super(1, index, identity, returnType, bundle, entry, serverBase, authorizationHelper);
        this.responseGenerator = responseGenerator;
        this.daoProvider = daoProvider;
        this.exceptionHandler = exceptionHandler;
        this.parameterConverter = parameterConverter;
        this.eventGenerator = eventGenerator;
    }

    @Override
    public void execute(Map<String, IdType> idTranslationTable, Connection connection, ValidationHelper validationHelper, SnapshotGenerator snapshotGenerator) throws SQLException, WebApplicationException {
        UriComponents componentes = UriComponentsBuilder.fromUriString((String)this.entry.getRequest().getUrl()).build();
        this.resourceTypeName = (String)componentes.getPathSegments().get(0);
        if (componentes.getPathSegments().size() == 2 && componentes.getQueryParams().isEmpty()) {
            this.deleteById(idTranslationTable, connection, (String)componentes.getPathSegments().get(0), (String)componentes.getPathSegments().get(1));
        } else if (componentes.getPathSegments().size() == 1 && !componentes.getQueryParams().isEmpty()) {
            this.deleteByCondition(idTranslationTable, connection, (String)componentes.getPathSegments().get(0), this.parameterConverter.urlDecodeQueryParameters((Map<String, List<String>>)componentes.getQueryParams()));
        } else {
            throw new WebApplicationException(this.responseGenerator.badDeleteRequestUrl(this.index, this.entry.getRequest().getUrl()));
        }
    }

    private void deleteById(Map<String, IdType> idTranslationTable, Connection connection, String resourceTypeName, String id) {
        Optional<ResourceDao<?>> optDao = this.daoProvider.getDao(resourceTypeName);
        if (optDao.isEmpty()) {
            throw new WebApplicationException(this.responseGenerator.resourceTypeNotSupportedByImplementation(this.index, resourceTypeName));
        }
        ResourceDao<?> dao = optDao.get();
        UUID uuid = this.parameterConverter.toUuid(resourceTypeName, id);
        Optional dbResource = this.exceptionHandler.handleSqlException(() -> dao.readIncludingDeletedWithTransaction(connection, uuid));
        dbResource.ifPresent(oldResource -> this.authorizationHelper.checkDeleteAllowed(this.index, connection, this.identity, (Resource)oldResource));
        this.deleted = this.exceptionHandler.handleSqlAndResourceNotFoundException(resourceTypeName, () -> this.deleteWithTransaction(dao, connection, uuid));
        this.resourceType = dao.getResourceType();
        this.id = id;
        this.setNewIdIfResourceExistsInTranslationTable(idTranslationTable, id);
    }

    private void deleteByCondition(Map<String, IdType> idTranslationTable, Connection connection, String resourceTypeName, Map<String, List<String>> queryParameters) {
        Optional<ResourceDao<?>> dao = this.daoProvider.getDao(resourceTypeName);
        if (dao.isEmpty()) {
            throw new WebApplicationException(this.responseGenerator.resourceTypeNotSupportedByImplementation(this.index, resourceTypeName));
        }
        Optional<Resource> resourceToDelete = this.search(connection, dao.get(), queryParameters);
        if (resourceToDelete.isPresent()) {
            this.authorizationHelper.checkDeleteAllowed(this.index, connection, this.identity, resourceToDelete.get());
            this.deleted = this.exceptionHandler.handleSqlAndResourceNotFoundException(resourceTypeName, () -> this.deleteWithTransaction((ResourceDao)dao.get(), connection, this.parameterConverter.toUuid(resourceTypeName, ((Resource)resourceToDelete.get()).getIdElement().getIdPart())));
            this.resourceType = dao.get().getResourceType();
            this.id = resourceToDelete.get().getIdElement().getIdPart();
            this.setNewIdIfResourceExistsInTranslationTable(idTranslationTable, this.id);
        }
    }

    private void setNewIdIfResourceExistsInTranslationTable(Map<String, IdType> idTranslationTable, String id) {
        idTranslationTable.entrySet().stream().filter(e -> ((IdType)e.getValue()).equals((Object)new IdType(this.resourceTypeName, id))).findFirst().ifPresent(entry -> idTranslationTable.put((String)entry.getKey(), new IdType(this.resourceTypeName, UUID.randomUUID().toString())));
    }

    protected boolean deleteWithTransaction(ResourceDao<?> dao, Connection connection, UUID uuid) throws SQLException, ResourceNotFoundException {
        return dao.deleteWithTransaction(connection, uuid);
    }

    private Optional<Resource> search(Connection connection, ResourceDao<?> dao, Map<String, List<String>> queryParameters) {
        if (Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(queryParameters::containsKey)) {
            logger.warn("Query contains parameter not applicable in this conditional delete context: '{}', parameters {} will be ignored", (Object)UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap(queryParameters)).toUriString(), (Object)Arrays.toString(SearchQuery.STANDARD_PARAMETERS));
            queryParameters = queryParameters.entrySet().stream().filter(e -> !Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(p -> p.equals(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        SearchQuery<?> query = dao.createSearchQueryWithoutUserFilter(1, 1);
        query.configureParameters(queryParameters);
        List<SearchQueryParameterError> unsupportedQueryParameters = query.getUnsupportedQueryParameters();
        if (!unsupportedQueryParameters.isEmpty()) {
            throw new WebApplicationException(this.responseGenerator.badConditionalDeleteRequest(this.index, UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap(queryParameters)).toUriString(), unsupportedQueryParameters));
        }
        PartialResult result = this.exceptionHandler.handleSqlException(() -> dao.searchWithTransaction(connection, query));
        if (result.getTotal() <= 0) {
            return Optional.empty();
        }
        if (result.getTotal() == 1) {
            return Optional.of((Resource)result.getPartialResult().get(0));
        }
        throw new WebApplicationException(this.responseGenerator.badConditionalDeleteRequestMultipleMatches(this.index, this.resourceTypeName, UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap(queryParameters)).toUriString()));
    }

    @Override
    public Optional<Bundle.BundleEntryComponent> postExecute(Connection connection, EventHandler eventHandler) {
        try {
            if (this.deleted) {
                eventHandler.handleEvent(this.eventGenerator.newResourceDeletedEvent(this.resourceType, this.id));
            }
        }
        catch (Exception e) {
            logger.debug("Error while handling resource deleted event", (Throwable)e);
            logger.warn("Error while handling resource deleted event: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
        Bundle.BundleEntryComponent resultEntry = new Bundle.BundleEntryComponent();
        Bundle.BundleEntryResponseComponent response = resultEntry.getResponse();
        if (this.resourceTypeName != null && this.id != null) {
            response.setStatus(Response.Status.OK.getStatusCode() + " " + Response.Status.OK.getReasonPhrase());
            response.setOutcome((Resource)this.responseGenerator.resourceDeleted(this.resourceTypeName, this.id));
        } else {
            response.setStatus(Response.Status.NO_CONTENT.getStatusCode() + " " + Response.Status.NO_CONTENT.getReasonPhrase());
        }
        return Optional.of(resultEntry);
    }

    @Override
    public String getResourceTypeName() {
        return this.resourceTypeName;
    }
}

