/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.StructureDefinitionDao;
import dev.dsf.fhir.dao.command.AuthorizationHelper;
import dev.dsf.fhir.dao.command.CreateCommand;
import dev.dsf.fhir.dao.command.ValidationHelper;
import dev.dsf.fhir.event.EventGenerator;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.prefer.PreferReturnType;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.validation.SnapshotGenerator;
import jakarta.ws.rs.WebApplicationException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateStructureDefinitionCommand
extends CreateCommand<StructureDefinition, StructureDefinitionDao> {
    private static final Logger logger = LoggerFactory.getLogger(CreateStructureDefinitionCommand.class);
    private final StructureDefinitionDao snapshotDao;
    private StructureDefinition resourceWithSnapshot;

    public CreateStructureDefinitionCommand(int index, Identity identity, PreferReturnType returnType, Bundle bundle, Bundle.BundleEntryComponent entry, String serverBase, AuthorizationHelper authorizationHelper, StructureDefinition resource, StructureDefinitionDao dao, ExceptionHandler exceptionHandler, ParameterConverter parameterConverter, ResponseGenerator responseGenerator, ReferenceExtractor referenceExtractor, ReferenceResolver referenceResolver, ReferenceCleaner referenceCleaner, EventGenerator eventGenerator, StructureDefinitionDao snapshotDao) {
        super(index, identity, returnType, bundle, entry, serverBase, authorizationHelper, resource, dao, exceptionHandler, parameterConverter, responseGenerator, referenceExtractor, referenceResolver, referenceCleaner, eventGenerator);
        this.snapshotDao = snapshotDao;
    }

    @Override
    public void preExecute(Map<String, IdType> idTranslationTable, Connection connection, ValidationHelper validationHelper, SnapshotGenerator snapshotGenerator) {
        this.resourceWithSnapshot = ((StructureDefinition)this.resource).hasSnapshot() ? ((StructureDefinition)this.resource).copy() : this.generateSnapshot(snapshotGenerator, ((StructureDefinition)this.resource).copy());
        ((StructureDefinition)this.resource).setSnapshot(null);
        super.preExecute(idTranslationTable, connection, validationHelper, snapshotGenerator);
    }

    private StructureDefinition generateSnapshot(SnapshotGenerator snapshotGenerator, StructureDefinition resource) {
        logger.debug("Generating snapshot for bundle entry at index {}", (Object)this.index);
        SnapshotGenerator.SnapshotWithValidationMessages s = snapshotGenerator.generateSnapshot(resource);
        if (s.getMessages().stream().anyMatch(m -> ValidationMessage.IssueSeverity.FATAL.equals((Object)m.getLevel()) || ValidationMessage.IssueSeverity.ERROR.equals((Object)m.getLevel()))) {
            throw new WebApplicationException(this.responseGenerator.unableToGenerateSnapshot(resource, this.index, s.getMessages()));
        }
        return s.getSnapshot();
    }

    @Override
    protected StructureDefinition createWithTransactionAndId(Connection connection, StructureDefinition resource, UUID uuid) throws SQLException {
        StructureDefinition created = super.createWithTransactionAndId(connection, resource, uuid);
        if (this.resourceWithSnapshot != null) {
            try {
                this.snapshotDao.createWithTransactionAndId(connection, this.resourceWithSnapshot, uuid);
            }
            catch (SQLException e) {
                logger.debug("Error while creating StructureDefinition snapshot", (Throwable)e);
                logger.warn("Error while creating StructureDefinition snapshot: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                throw e;
            }
        }
        return created;
    }
}

