/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import ca.uhn.fhir.validation.ValidationResult;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.command.AbstractCommandWithResource;
import dev.dsf.fhir.dao.command.AuthorizationHelper;
import dev.dsf.fhir.dao.command.ModifyingCommand;
import dev.dsf.fhir.dao.command.ValidationHelper;
import dev.dsf.fhir.dao.exception.ResourceDeletedException;
import dev.dsf.fhir.dao.exception.ResourceNotFoundException;
import dev.dsf.fhir.event.EventGenerator;
import dev.dsf.fhir.event.EventHandler;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.prefer.PreferReturnType;
import dev.dsf.fhir.search.PartialResult;
import dev.dsf.fhir.search.SearchQuery;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.validation.SnapshotGenerator;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class CreateCommand<R extends Resource, D extends ResourceDao<R>>
extends AbstractCommandWithResource<R, D>
implements ModifyingCommand {
    private static final Logger logger = LoggerFactory.getLogger(CreateCommand.class);
    protected final ResponseGenerator responseGenerator;
    protected final ReferenceCleaner referenceCleaner;
    protected final EventGenerator eventGenerator;
    protected R createdResource;
    protected Response responseResult;
    protected ValidationResult validationResult;

    public CreateCommand(int index, Identity identity, PreferReturnType returnType, Bundle bundle, Bundle.BundleEntryComponent entry, String serverBase, AuthorizationHelper authorizationHelper, R resource, D dao, ExceptionHandler exceptionHandler, ParameterConverter parameterConverter, ResponseGenerator responseGenerator, ReferenceExtractor referenceExtractor, ReferenceResolver referenceResolver, ReferenceCleaner referenceCleaner, EventGenerator eventGenerator) {
        super(2, index, identity, returnType, bundle, entry, serverBase, authorizationHelper, resource, dao, exceptionHandler, parameterConverter, responseGenerator, referenceExtractor, referenceResolver);
        this.responseGenerator = responseGenerator;
        this.referenceCleaner = referenceCleaner;
        this.eventGenerator = eventGenerator;
    }

    @Override
    public void preExecute(Map<String, IdType> idTranslationTable, Connection connection, ValidationHelper validationHelper, SnapshotGenerator snapshotGenerator) {
        UriComponents eruComponentes = UriComponentsBuilder.fromUriString((String)this.entry.getRequest().getUrl()).build();
        if (eruComponentes.getPathSegments().size() == 1 && eruComponentes.getQueryParams().isEmpty()) {
            if (!this.entry.hasFullUrl() || !this.entry.getFullUrl().startsWith("urn:uuid:")) {
                throw new WebApplicationException(this.responseGenerator.badCreateRequestUrl(this.index, this.entry.getRequest().getUrl()));
            }
            if (this.resource.hasIdElement() && !this.resource.getIdElement().getValue().startsWith("urn:uuid:")) {
                throw new WebApplicationException(this.responseGenerator.bundleEntryBadResourceId(this.index, this.getResourceTypeName(), "urn:uuid:"));
            }
            if (this.resource.hasIdElement() && !this.entry.getFullUrl().equals(this.resource.getIdElement().getValue())) {
                throw new WebApplicationException(this.responseGenerator.badBundleEntryFullUrlVsResourceId(this.index, this.entry.getFullUrl(), this.resource.getIdElement().getValue()));
            }
        } else {
            throw new WebApplicationException(this.responseGenerator.badCreateRequestUrl(this.index, this.entry.getRequest().getUrl()));
        }
        this.addToIdTranslationTable(idTranslationTable, connection);
    }

    private void addToIdTranslationTable(Map<String, IdType> idTranslationTable, Connection connection) {
        Optional<Resource> exists = this.checkAlreadyExists(connection, this.entry.getRequest().getIfNoneExist(), this.getResourceTypeName());
        if (exists.isEmpty()) {
            UUID id = UUID.randomUUID();
            idTranslationTable.put(this.entry.getFullUrl(), new IdType(this.getResourceTypeName(), id.toString()));
        } else {
            Resource existingResource = exists.get();
            idTranslationTable.put(this.entry.getFullUrl(), new IdType(existingResource.getResourceType().toString(), existingResource.getIdElement().getIdPart()));
            this.responseResult = this.responseGenerator.oneExists(existingResource, this.entry.getRequest().getIfNoneExist());
        }
    }

    @Override
    public void execute(Map<String, IdType> idTranslationTable, Connection connection, ValidationHelper validationHelper, SnapshotGenerator snapshotGenerator) throws SQLException, WebApplicationException {
        this.referencesHelper.resolveTemporaryAndConditionalReferencesOrLiteralInternalRelatedArtifactOrAttachmentUrls(idTranslationTable, connection);
        Optional<Resource> exists = this.checkAlreadyExists(connection, this.entry.getRequest().getIfNoneExist(), this.getResourceTypeName());
        if (exists.isEmpty()) {
            this.responseResult = null;
            this.validationResult = validationHelper.checkResourceValidForCreate(this.identity, this.resource);
            this.referencesHelper.resolveLogicalReferences(connection);
            this.authorizationHelper.checkCreateAllowed(this.index, connection, this.identity, this.resource);
            this.createdResource = this.createWithTransactionAndId(connection, this.resource, this.getId(idTranslationTable));
        } else if (this.responseResult == null) {
            this.responseResult = this.responseGenerator.oneExists(exists.get(), this.entry.getRequest().getIfNoneExist());
        }
    }

    protected R createWithTransactionAndId(Connection connection, R resource, UUID uuid) throws SQLException {
        return this.dao.createWithTransactionAndId(connection, resource, uuid);
    }

    private UUID getId(Map<String, IdType> idTranslationTable) {
        Optional<UUID> uuid;
        IdType idType = idTranslationTable.get(this.entry.getFullUrl());
        if (idType != null && (uuid = this.parameterConverter.toUuid(idType.getIdPart())).isPresent()) {
            return uuid.get();
        }
        throw new RuntimeException("Error while retrieving id from id translation table");
    }

    private Optional<Resource> checkAlreadyExists(Connection connection, String ifNoneExist, String resourceTypeName) throws WebApplicationException {
        UriComponents componentes;
        String path;
        if (ifNoneExist == null) {
            return Optional.empty();
        }
        if (((String)ifNoneExist).isBlank()) {
            throw new WebApplicationException(this.responseGenerator.badIfNoneExistHeaderValue((String)ifNoneExist));
        }
        if (!((String)ifNoneExist).contains("?")) {
            ifNoneExist = "?" + (String)ifNoneExist;
        }
        if ((path = (componentes = UriComponentsBuilder.fromUriString((String)ifNoneExist).build()).getPath()) != null && !path.isBlank()) {
            throw new WebApplicationException(this.responseGenerator.badIfNoneExistHeaderValue((String)ifNoneExist));
        }
        Map<String, List<String>> queryParameters = this.parameterConverter.urlDecodeQueryParameters((Map<String, List<String>>)componentes.getQueryParams());
        if (Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(queryParameters::containsKey)) {
            logger.warn("{} Header contains query parameter not applicable in this conditional create context: '{}', parameters {} will be ignored", new Object[]{"If-None-Exist", ifNoneExist, Arrays.toString(SearchQuery.STANDARD_PARAMETERS)});
            queryParameters = queryParameters.entrySet().stream().filter(e -> !Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(p -> p.equals(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        SearchQuery query = this.dao.createSearchQueryWithoutUserFilter(1, 1);
        query.configureParameters(queryParameters);
        List<SearchQueryParameterError> unsupportedQueryParameters = query.getUnsupportedQueryParameters();
        if (!unsupportedQueryParameters.isEmpty()) {
            throw new WebApplicationException(this.responseGenerator.badIfNoneExistHeaderValue((String)ifNoneExist, unsupportedQueryParameters));
        }
        PartialResult result = this.exceptionHandler.handleSqlException(() -> this.dao.searchWithTransaction(connection, query));
        if (result.getTotal() == 1) {
            return Optional.of((Resource)result.getPartialResult().get(0));
        }
        if (result.getTotal() > 1) {
            throw new WebApplicationException(this.responseGenerator.multipleExists(resourceTypeName, (String)ifNoneExist));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Bundle.BundleEntryComponent> postExecute(Connection connection, EventHandler eventHandler) {
        if (this.responseResult == null) {
            R createdResourceWithResolvedReferences = this.latestOrErrorIfDeletedOrNotFound(connection, (Resource)this.createdResource);
            try {
                this.referenceCleaner.cleanLiteralReferences(createdResourceWithResolvedReferences);
                eventHandler.handleEvent(this.eventGenerator.newResourceCreatedEvent((Resource)createdResourceWithResolvedReferences));
            }
            catch (Exception e) {
                logger.debug("Error while handling resource created event", (Throwable)e);
                logger.warn("Error while handling resource created event: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            }
            IdType location = createdResourceWithResolvedReferences.getIdElement().withServerBase(this.serverBase, createdResourceWithResolvedReferences.getResourceType().name());
            Bundle.BundleEntryComponent resultEntry = new Bundle.BundleEntryComponent();
            resultEntry.setFullUrl(location.toVersionless().toString());
            if (PreferReturnType.REPRESENTATION.equals((Object)this.returnType)) {
                resultEntry.setResource(createdResourceWithResolvedReferences);
            } else if (PreferReturnType.OPERATION_OUTCOME.equals((Object)this.returnType)) {
                OperationOutcome outcome = this.responseGenerator.created(location.toString(), (Resource)createdResourceWithResolvedReferences);
                this.validationResult.populateOperationOutcome((IBaseOperationOutcome)outcome);
                resultEntry.getResponse().setOutcome((Resource)outcome);
            }
            Bundle.BundleEntryResponseComponent response = resultEntry.getResponse();
            response.setStatus(Response.Status.CREATED.getStatusCode() + " " + Response.Status.CREATED.getReasonPhrase());
            response.setLocation(location.getValue());
            response.setEtag(RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class).toString((Object)new EntityTag(createdResourceWithResolvedReferences.getMeta().getVersionId(), true)));
            response.setLastModified(createdResourceWithResolvedReferences.getMeta().getLastUpdated());
            return Optional.of(resultEntry);
        }
        Bundle.BundleEntryComponent resultEntry = new Bundle.BundleEntryComponent();
        Bundle.BundleEntryResponseComponent response = resultEntry.getResponse();
        response.setStatus(this.responseResult.getStatusInfo().getStatusCode() + " " + this.responseResult.getStatusInfo().getReasonPhrase());
        if (this.responseResult.getLocation() != null) {
            response.setLocation(this.responseResult.getLocation().toString());
        }
        if (this.responseResult.getEntityTag() != null) {
            response.setEtag(this.responseResult.getEntityTag().getValue());
        }
        if (this.responseResult.getLastModified() != null) {
            response.setLastModified(this.responseResult.getLastModified());
        }
        return Optional.of(resultEntry);
    }

    private R latestOrErrorIfDeletedOrNotFound(Connection connection, Resource resource) {
        try {
            return (R)((Resource)this.dao.readWithTransaction(connection, this.parameterConverter.toUuid(resource.getResourceType().name(), resource.getIdElement().getIdPart())).orElseThrow(() -> new ResourceNotFoundException(resource.getIdElement().getIdPart())));
        }
        catch (ResourceDeletedException | ResourceNotFoundException | SQLException e) {
            logger.debug("Error while reading resource from db", (Throwable)e);
            logger.warn("Error while reading resource from db: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

