/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import dev.dsf.fhir.dao.command.AbstractCommandList;
import dev.dsf.fhir.dao.command.Command;
import dev.dsf.fhir.dao.command.CommandList;
import dev.dsf.fhir.dao.command.ValidationHelper;
import dev.dsf.fhir.event.EventHandler;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.validation.SnapshotGenerator;
import jakarta.ws.rs.WebApplicationException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCommandList
extends AbstractCommandList
implements CommandList {
    private static final Logger logger = LoggerFactory.getLogger(BatchCommandList.class);
    private final ValidationHelper validationHelper;
    private final SnapshotGenerator snapshotGenerator;
    private final EventHandler eventHandler;

    public BatchCommandList(DataSource dataSource, ExceptionHandler exceptionHandler, List<? extends Command> commands, ValidationHelper validationHelper, SnapshotGenerator snapshotGenerator, EventHandler eventHandler) {
        super(dataSource, exceptionHandler, commands);
        this.validationHelper = validationHelper;
        this.snapshotGenerator = snapshotGenerator;
        this.eventHandler = eventHandler;
    }

    @Override
    public Bundle execute() throws WebApplicationException {
        Bundle bundle;
        block10: {
            Connection connection = this.dataSource.getConnection();
            try {
                boolean initialReadOnly = connection.isReadOnly();
                boolean initialAutoCommit = connection.getAutoCommit();
                int initialTransactionIsolationLevel = connection.getTransactionIsolation();
                logger.debug("Running batch with DB connection setting: read-only {}, auto-commit {}, transaction-isolation-level {}", new Object[]{initialReadOnly, initialAutoCommit, this.getTransactionIsolationLevelString(initialTransactionIsolationLevel)});
                HashMap<Integer, Exception> caughtExceptions = new HashMap<Integer, Exception>((int)((double)this.commands.size() / 0.75) + 1);
                HashMap<String, IdType> idTranslationTable = new HashMap<String, IdType>();
                if (this.hasModifyingCommands) {
                    logger.debug("Elevating DB connection setting to: read-only {}, auto-commit {}, transaction-isolation-level {}", new Object[]{false, false, this.getTransactionIsolationLevelString(4)});
                    connection.setReadOnly(false);
                    connection.setAutoCommit(false);
                    connection.setTransactionIsolation(4);
                }
                this.commands.forEach(this.preExecute(idTranslationTable, connection, caughtExceptions));
                this.commands.forEach(this.execute(idTranslationTable, connection, caughtExceptions));
                if (this.hasModifyingCommands) {
                    logger.debug("Reseting DB connection setting to: read-only {}, auto-commit {}, transaction-isolation-level {}", new Object[]{initialReadOnly, initialAutoCommit, this.getTransactionIsolationLevelString(initialTransactionIsolationLevel)});
                    connection.setReadOnly(initialReadOnly);
                    connection.setAutoCommit(initialAutoCommit);
                    connection.setTransactionIsolation(initialTransactionIsolationLevel);
                }
                HashMap<Integer, Bundle.BundleEntryComponent> results = new HashMap<Integer, Bundle.BundleEntryComponent>((int)((double)this.commands.size() / 0.75) + 1);
                this.commands.forEach(this.postExecute(connection, caughtExceptions, results));
                caughtExceptions.forEach((k, v) -> results.put((Integer)k, this.toEntry((Exception)v)));
                results.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(e -> {
                    Command command = (Command)this.commands.get((Integer)e.getKey());
                    Bundle.BundleEntryComponent result = (Bundle.BundleEntryComponent)e.getValue();
                    this.auditLogResult(command, result);
                });
                Bundle result = new Bundle();
                result.setType(Bundle.BundleType.BATCHRESPONSE);
                results.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).forEach(arg_0 -> ((Bundle)result).addEntry(arg_0));
                bundle = result;
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    throw this.exceptionHandler.internalServerErrorBundleTransaction(e2);
                }
            }
            connection.close();
        }
        return bundle;
    }

    private String getTransactionIsolationLevelString(int level) {
        return switch (level) {
            case 0 -> "NONE";
            case 1 -> "READ_UNCOMMITTED";
            case 2 -> "READ_COMMITTED";
            case 4 -> "REPEATABLE_READ";
            case 8 -> "SERIALIZABLE";
            default -> "?";
        };
    }

    private Consumer<Command> preExecute(Map<String, IdType> idTranslationTable, Connection connection, Map<Integer, Exception> caughtExceptions) {
        return command -> {
            try {
                if (!caughtExceptions.containsKey(command.getIndex())) {
                    logger.debug("Running pre-execute of command {} for entry at index {}", (Object)command.getClass().getName(), (Object)command.getIndex());
                    command.preExecute(idTranslationTable, connection, this.validationHelper, this.snapshotGenerator);
                } else {
                    logger.info("Skipping pre-execute of command {} for entry at index {}, caught exception {}", new Object[]{command.getClass().getName(), command.getIndex(), ((Exception)caughtExceptions.get(command.getIndex())).getClass().getName() + ": " + ((Exception)caughtExceptions.get(command.getIndex())).getMessage()});
                }
            }
            catch (Exception e) {
                logger.debug("Error while running pre-execute of command {} for entry at index {}", new Object[]{command.getClass().getName(), command.getIndex(), e});
                logger.warn("Error while running pre-execute of command {} for entry at index {}: {} - {}", new Object[]{command.getClass().getName(), command.getIndex(), e.getClass().getName(), e.getMessage()});
                caughtExceptions.put(command.getIndex(), e);
            }
        };
    }

    private Consumer<Command> execute(Map<String, IdType> idTranslationTable, Connection connection, Map<Integer, Exception> caughtExceptions) {
        return command -> {
            try {
                if (!caughtExceptions.containsKey(command.getIndex())) {
                    logger.debug("Running execute of command {} for entry at index {}", (Object)command.getClass().getName(), (Object)command.getIndex());
                    command.execute(idTranslationTable, connection, this.validationHelper, this.snapshotGenerator);
                } else {
                    logger.info("Skipping execute of command {} for entry at index {}, caught exception {}", new Object[]{command.getClass().getName(), command.getIndex(), ((Exception)caughtExceptions.get(command.getIndex())).getClass().getName() + ": " + ((Exception)caughtExceptions.get(command.getIndex())).getMessage()});
                }
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (Exception e) {
                logger.debug("Error while executing command {}, rolling back transaction for entry at index {}", new Object[]{command.getClass().getName(), command.getIndex(), e});
                logger.warn("Error while executing command {}, rolling back transaction for entry at index {}: {} - {}", new Object[]{command.getClass().getName(), command.getIndex(), e.getClass().getName(), e.getMessage()});
                caughtExceptions.put(command.getIndex(), e);
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException e1) {
                    logger.debug("Error while executing command {}, error while rolling back transaction for entry at index {}", new Object[]{command.getClass().getName(), command.getIndex(), e1});
                    logger.warn("Error while executing command {}, error while rolling back transaction for entry at index {}: {} - {}", new Object[]{command.getClass().getName(), command.getIndex(), e1.getClass().getName(), e1.getMessage()});
                    caughtExceptions.put(command.getIndex(), e1);
                }
            }
        };
    }

    private Consumer<Command> postExecute(Connection connection, Map<Integer, Exception> caughtExceptions, Map<Integer, Bundle.BundleEntryComponent> results) {
        return command -> {
            try {
                if (!caughtExceptions.containsKey(command.getIndex())) {
                    logger.debug("Running post-execute of command {} for entry at index {}", (Object)command.getClass().getName(), (Object)command.getIndex());
                    Optional<Bundle.BundleEntryComponent> optResult = command.postExecute(connection, this.eventHandler);
                    optResult.ifPresent(result -> results.put(command.getIndex(), (Bundle.BundleEntryComponent)result));
                } else {
                    logger.info("Skipping post-execute of command {} for entry at index {}, caught exception {}", new Object[]{command.getClass().getName(), command.getIndex(), ((Exception)caughtExceptions.get(command.getIndex())).getClass().getName() + ": " + ((Exception)caughtExceptions.get(command.getIndex())).getMessage()});
                }
            }
            catch (Exception e) {
                logger.debug("Error while running post-execute of command {} for entry at index {}", new Object[]{command.getClass().getName(), command.getIndex(), e});
                logger.warn("Error while running post-execute of command {} for entry at index {}: {} - {}", new Object[]{command.getClass().getName(), command.getIndex(), e.getClass().getName(), e.getMessage()});
                caughtExceptions.put(command.getIndex(), e);
            }
        };
    }
}

