/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authorization.AbstractAuthorizationRule;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.dao.QuestionnaireResponseDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.service.ReferenceResolver;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.StringType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionnaireResponseAuthorizationRule
extends AbstractAuthorizationRule<QuestionnaireResponse, QuestionnaireResponseDao> {
    private static final Logger logger = LoggerFactory.getLogger(QuestionnaireResponseAuthorizationRule.class);
    private static final String CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_BUSINESS_KEY = "business-key";
    private static final String CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_USER_TASK_ID = "user-task-id";

    public QuestionnaireResponseAuthorizationRule(DaoProvider daoProvider, String serverBase, ReferenceResolver referenceResolver, OrganizationProvider organizationProvider, ReadAccessHelper readAccessHelper, ParameterConverter parameterConverter) {
        super(QuestionnaireResponse.class, daoProvider, serverBase, referenceResolver, organizationProvider, readAccessHelper, parameterConverter);
    }

    @Override
    public Optional<String> reasonCreateAllowed(Connection connection, Identity identity, QuestionnaireResponse newResource) {
        if (identity.isLocalIdentity() && identity.hasDsfRole((DsfRole)FhirServerRole.CREATE)) {
            Optional<String> errors = this.newResourceOk(newResource, EnumSet.of(QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS));
            if (errors.isEmpty()) {
                logger.info("Create of QuestionnaireResponse authorized for local user '{}'", (Object)identity.getName());
                return Optional.of("local user");
            }
            logger.warn("Create of QuestionnaireResponse unauthorized, {}", (Object)errors.get());
            return Optional.empty();
        }
        logger.warn("Create of QuestionnaireResponse unauthorized, not a local user");
        return Optional.empty();
    }

    private Optional<String> newResourceOk(QuestionnaireResponse newResource, EnumSet<QuestionnaireResponse.QuestionnaireResponseStatus> allowedStatus) {
        ArrayList<String> errors = new ArrayList<String>();
        if (newResource.hasStatus()) {
            if (!allowedStatus.contains(newResource.getStatus())) {
                errors.add("QuestionnaireResponse.status not one of " + allowedStatus);
            }
        } else {
            errors.add("QuestionnaireResponse.status missing");
        }
        this.getItemAndValidate(newResource, CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_USER_TASK_ID, errors);
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    private Optional<String> getItemAndValidate(QuestionnaireResponse newResource, String linkId, List<String> errors) {
        List userTaskIds = newResource.getItem().stream().filter(QuestionnaireResponse.QuestionnaireResponseItemComponent::hasLinkId).filter(i -> linkId.equals(i.getLinkId())).collect(Collectors.toList());
        if (userTaskIds.size() != 1) {
            if (errors != null) {
                errors.add("QuestionnaireResponse.item('user-task-id') missing or more than one");
            }
            return Optional.empty();
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent item = (QuestionnaireResponse.QuestionnaireResponseItemComponent)userTaskIds.get(0);
        if (!item.hasAnswer() || item.getAnswer().size() != 1) {
            if (errors != null) {
                errors.add("QuestionnaireResponse.item('user-task-id').answer missing or more than one");
            }
            return Optional.empty();
        }
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent answer = item.getAnswerFirstRep();
        if (!answer.hasValue() || !(answer.getValue() instanceof StringType)) {
            if (errors != null) {
                errors.add("QuestionnaireResponse.item('user-task-id').answer.value missing or not a string");
            }
            return Optional.empty();
        }
        StringType value = (StringType)answer.getValue();
        if (!value.hasValue()) {
            if (errors != null) {
                errors.add("QuestionnaireResponse.item('user-task-id').answer.value is blank");
            }
            return Optional.empty();
        }
        return Optional.of((String)value.getValue());
    }

    @Override
    public Optional<String> reasonReadAllowed(Connection connection, Identity identity, QuestionnaireResponse existingResource) {
        if (identity.isLocalIdentity() && identity.hasDsfRole((DsfRole)FhirServerRole.READ)) {
            logger.info("Read of QuestionnaireResponse authorized for local user '{}'", (Object)identity.getName());
            return Optional.of("task.restriction.recipient resolved and local user part of referenced organization");
        }
        logger.warn("Read of QuestionnaireResponse unauthorized, not a local user");
        return Optional.empty();
    }

    @Override
    public Optional<String> reasonUpdateAllowed(Connection connection, Identity identity, QuestionnaireResponse oldResource, QuestionnaireResponse newResource) {
        if (identity.isLocalIdentity() && identity.hasDsfRole((DsfRole)FhirServerRole.UPDATE)) {
            Optional<String> errors = this.newResourceOk(newResource, EnumSet.of(QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED, QuestionnaireResponse.QuestionnaireResponseStatus.STOPPED));
            if (errors.isEmpty()) {
                if (this.modificationsOk(oldResource, newResource)) {
                    logger.info("Update of QuestionnaireResponse authorized for local user '{}', modification allowed", (Object)identity.getName());
                    return Optional.of("local user; modification allowed");
                }
                logger.warn("Update of QuestionnaireResponse unauthorized, modification not allowed");
                return Optional.empty();
            }
            logger.warn("Update of QuestionnaireResponse unauthorized, {}", (Object)errors.get());
            return Optional.empty();
        }
        logger.warn("Update of QuestionnaireResponse unauthorized, not a local user");
        return Optional.empty();
    }

    private boolean modificationsOk(QuestionnaireResponse oldResource, QuestionnaireResponse newResource) {
        String newUserTaskId;
        String oldUserTaskId;
        boolean userTaskIdOk;
        boolean statusModificationOk;
        boolean bl = statusModificationOk = QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS.equals((Object)oldResource.getStatus()) && (QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED.equals((Object)newResource.getStatus()) || QuestionnaireResponse.QuestionnaireResponseStatus.STOPPED.equals((Object)newResource.getStatus()));
        if (!statusModificationOk) {
            logger.warn("Modifications only allowed if status changes from '{}' to '{}', current status of old resource is '{}' and of new resource is '{}'", new Object[]{QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS, QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED + "|" + QuestionnaireResponse.QuestionnaireResponseStatus.STOPPED, oldResource.getStatus(), newResource.getStatus()});
        }
        if (!(userTaskIdOk = Objects.equals(oldUserTaskId = (String)this.getItemAndValidate(oldResource, CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_USER_TASK_ID, new ArrayList<String>()).orElse(null), newUserTaskId = (String)this.getItemAndValidate(newResource, CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_USER_TASK_ID, new ArrayList<String>()).orElse(null)))) {
            logger.warn("Modifications only allowed if item.answer with linkId '{}' not changed, change from '{}' to '{}' not allowed", new Object[]{CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_USER_TASK_ID, oldUserTaskId, newUserTaskId});
        }
        String oldBusinessKey = this.getItemAndValidate(oldResource, CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_BUSINESS_KEY, new ArrayList<String>()).orElse(null);
        String newBusinessKey = this.getItemAndValidate(newResource, CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_BUSINESS_KEY, new ArrayList<String>()).orElse(null);
        boolean businesssKeyOk = Objects.equals(oldBusinessKey, newBusinessKey);
        if (!userTaskIdOk) {
            logger.warn("Modifications only allowed if item.answer with linkId '{}' not changed, change from '{}' to '{}' not allowed", new Object[]{CODESYSTEM_DSF_BPMN_USER_TASK_VALUE_BUSINESS_KEY, oldUserTaskId, newUserTaskId});
        }
        return statusModificationOk && userTaskIdOk && businesssKeyOk;
    }

    @Override
    public Optional<String> reasonDeleteAllowed(Connection connection, Identity identity, QuestionnaireResponse oldResource) {
        if (identity.isLocalIdentity() && identity.hasDsfRole((DsfRole)FhirServerRole.DELETE)) {
            logger.info("Delete of QuestionnaireResponse authorized for local user '{}'", (Object)identity.getName());
            return Optional.of("local user");
        }
        logger.warn("Delete of QuestionnaireResponse unauthorized, not a local user");
        return Optional.empty();
    }
}

