/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authorization.AbstractMetaTagAuthorizationRule;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.dao.LocationDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.service.ReferenceResolver;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Resource;

public class LocationAuthorizationRule
extends AbstractMetaTagAuthorizationRule<Location, LocationDao> {
    public LocationAuthorizationRule(DaoProvider daoProvider, String serverBase, ReferenceResolver referenceResolver, OrganizationProvider organizationProvider, ReadAccessHelper readAccessHelper, ParameterConverter parameterConverter) {
        super(Location.class, daoProvider, serverBase, referenceResolver, organizationProvider, readAccessHelper, parameterConverter);
    }

    @Override
    protected Optional<String> newResourceOkForCreate(Connection connection, Identity identity, Location newResource) {
        return this.newResourceOk(connection, newResource);
    }

    @Override
    protected Optional<String> newResourceOkForUpdate(Connection connection, Identity identity, Location newResource) {
        return this.newResourceOk(connection, newResource);
    }

    private Optional<String> newResourceOk(Connection connection, Location newResource) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.hasValidReadAccessTag(connection, (Resource)newResource)) {
            errors.add("Location is missing valid read access tag");
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    @Override
    protected boolean resourceExists(Connection connection, Location newResource) {
        return false;
    }

    @Override
    protected boolean modificationsOk(Connection connection, Location oldResource, Location newResource) {
        return true;
    }
}

