/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authentication;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.AbstractProvider;
import dev.dsf.fhir.authentication.OrganizationIdentityImpl;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.dao.OrganizationDao;
import dev.dsf.fhir.help.ExceptionHandler;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.r4.model.Organization;
import org.springframework.beans.factory.InitializingBean;

public class OrganizationProviderImpl
extends AbstractProvider
implements OrganizationProvider,
InitializingBean {
    private final OrganizationDao dao;
    private final ExceptionHandler exceptionHandler;
    private final String localOrganizationIdentifierValue;

    public OrganizationProviderImpl(OrganizationDao dao, ExceptionHandler exceptionHandler, String localOrganizationIdentifierValue) {
        this.dao = dao;
        this.exceptionHandler = exceptionHandler;
        this.localOrganizationIdentifierValue = localOrganizationIdentifierValue;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.dao, "dao");
        Objects.requireNonNull(this.exceptionHandler, "exceptionHandler");
        Objects.requireNonNull(this.localOrganizationIdentifierValue, "localOrganizationIdentifierValue");
    }

    private Optional<Organization> getOrganization(String thumbprint) {
        return this.exceptionHandler.catchAndLogSqlExceptionAndIfReturn(() -> this.dao.readActiveNotDeletedByThumbprint(thumbprint), Optional::empty);
    }

    @Override
    public Optional<Organization> getOrganization(X509Certificate certificate) {
        if (certificate == null) {
            return Optional.empty();
        }
        String thumbprint = this.getThumbprint(certificate);
        return this.getOrganization(thumbprint);
    }

    @Override
    public Optional<Organization> getLocalOrganization() {
        return this.exceptionHandler.catchAndLogSqlExceptionAndIfReturn(() -> this.dao.readActiveNotDeletedByIdentifier(this.localOrganizationIdentifierValue), Optional::empty);
    }

    @Override
    public String getLocalOrganizationIdentifierValue() {
        return this.localOrganizationIdentifierValue;
    }

    @Override
    public Optional<Identity> getLocalOrganizationAsIdentity() {
        return this.getLocalOrganization().map(o -> new OrganizationIdentityImpl(true, (Organization)o, Collections.emptySet(), null));
    }
}

