/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.HtmlGenerator;
import dev.dsf.fhir.adapter.ResourceHtmlGenerator;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class ActivityDefinitionHtmlGenerator
extends ResourceHtmlGenerator
implements HtmlGenerator<ActivityDefinition> {
    private static final String EXTENSION_PROCESS_AUTHORIZATION = "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization";
    private static final String EXTENSION_PROCESS_AUTHORIZATION_TASK_PROFILE = "task-profile";
    private static final String EXTENSION_PROCESS_AUTHORIZATION_MESSAGE_NAME = "message-name";
    private static final String EXTENSION_PROCESS_AUTHORIZATION_REQUESTER = "requester";
    private static final String EXTENSION_PROCESS_AUTHORIZATION_RECIPIENT = "recipient";

    @Override
    public Class<ActivityDefinition> getResourceType() {
        return ActivityDefinition.class;
    }

    @Override
    public void writeHtml(URI resourceUri, ActivityDefinition resource, OutputStreamWriter out) throws IOException {
        List<Extension> processAuthorizations;
        out.write("<div class=\"resource\">\n");
        out.write("<div class=\"row\" status=\"" + (resource.hasStatus() ? resource.getStatus().toCode() : "") + "\">\n");
        out.write("</div>\n");
        this.writeMeta((Resource)resource, out);
        this.writeRow("Status", resource.hasStatus() ? resource.getStatus().toCode() : "", out);
        this.writeSectionHeader("Activity Definition", out);
        if (resource.hasUrl()) {
            this.writeRow("Process", resource.getUrl() + (String)(resource.hasVersion() ? " | " + resource.getVersion() : ""), out);
        }
        if (resource.hasTitle()) {
            this.writeRow("Title", resource.getTitle(), out);
        }
        if (resource.hasSubtitle()) {
            this.writeRow("Subtitle", resource.getSubtitle(), out);
        }
        if (resource.hasDescription()) {
            this.writeRow("Description", resource.getDescription(), out);
        }
        if (resource.hasPublisher()) {
            this.writeRow("Publisher", resource.getPublisher(), out);
        }
        if (resource.hasDate()) {
            this.writeRow("Date", this.format(resource.getDate(), DATE_FORMAT), out);
        }
        if (!(processAuthorizations = resource.getExtension().stream().filter(e -> EXTENSION_PROCESS_AUTHORIZATION.equals(e.getUrl())).toList()).isEmpty()) {
            for (int i = 0; i < processAuthorizations.size(); ++i) {
                this.writeProcessAuthorizationRow(processAuthorizations.get(i), "Authorization" + (String)(processAuthorizations.size() > 1 ? " " + (i + 1) : ""), out);
            }
        }
        out.write("</div>\n");
    }

    private void writeProcessAuthorizationRow(Extension extension, String header, OutputStreamWriter out) throws IOException {
        Optional<String> taskProfile = extension.getExtensionsByUrl(EXTENSION_PROCESS_AUTHORIZATION_TASK_PROFILE).stream().filter(e -> e.getValue() instanceof CanonicalType).map(e -> String.join((CharSequence)" | ", ((String)((CanonicalType)e.getValue()).getValue()).split("\\|"))).findFirst();
        Optional<String> messageName = extension.getExtensionsByUrl(EXTENSION_PROCESS_AUTHORIZATION_MESSAGE_NAME).stream().filter(e -> e.getValue() instanceof StringType).map(e -> (String)((StringType)e.getValue()).getValue()).findFirst();
        if (taskProfile.isPresent() || messageName.isPresent()) {
            this.writeSectionHeader(header, out);
            out.write("<div class=\"flex-element\">\n");
            if (messageName.isPresent()) {
                this.writeRowWithAdditionalRowClasses("Message-Name", messageName.get(), taskProfile.isPresent() ? "flex-element-33 flex-element-margin" : "flex-element-100", out);
            }
            if (taskProfile.isPresent()) {
                this.writeRowWithAdditionalRowClasses("Task Profile", taskProfile.get(), messageName.isPresent() ? "flex-element-67" : "flex-element-100", out);
            }
            out.write("</div>\n");
        }
        List<Coding> requester = extension.getExtensionsByUrl(EXTENSION_PROCESS_AUTHORIZATION_REQUESTER).stream().filter(e -> e.getValue() instanceof Coding).map(e -> (Coding)e.getValue()).toList();
        this.writeAuthorizationFor(requester, "Requester", out);
        List<Coding> recipient = extension.getExtensionsByUrl(EXTENSION_PROCESS_AUTHORIZATION_RECIPIENT).stream().filter(e -> e.getValue() instanceof Coding).map(e -> (Coding)e.getValue()).toList();
        this.writeAuthorizationFor(recipient, "Recipient", out);
    }

    private void writeAuthorizationFor(List<Coding> authorization, String header, OutputStreamWriter out) throws IOException {
        for (int i = 0; i < authorization.size(); ++i) {
            Object extension2;
            out.write("<div class=\"row authorization\">\n");
            out.write("<h3>" + header + (String)(authorization.size() > 1 ? " " + (i + 1) : "") + "</h3>\n");
            Coding authorizationCode = authorization.get(i);
            this.writeRowWithAdditionalRowClasses("Authorization Type", authorizationCode.getSystem() + " | <b>" + authorizationCode.getCode() + "</b>", "nested-row", out);
            this.writeCoding("Practitioner", (Type)authorizationCode, "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-practitioner", out);
            this.writeIdentifier("Organization", (Type)authorizationCode, "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization", out);
            List authorizationOrganizationPractitioner = authorizationCode.getExtensionsByUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization-practitioner");
            for (Object extension2 : authorizationOrganizationPractitioner) {
                this.writeIdentifier("Organization", (Type)extension2, "organization", out);
                this.writeCoding("Practitioner Role", (Type)extension2, "practitioner-role", out);
            }
            List authorizationParentOrganizationRole = authorizationCode.getExtensionsByUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-parent-organization-role");
            extension2 = authorizationParentOrganizationRole.iterator();
            while (extension2.hasNext()) {
                Extension extension3 = (Extension)extension2.next();
                this.writeIdentifier("Parent Organization", (Type)extension3, "parent-organization", out);
                this.writeCoding("Organization Role", (Type)extension3, "organization-role", out);
            }
            List authorizationParentOrganizationPractitionerRole = authorizationCode.getExtensionsByUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-parent-organization-role-practitioner");
            for (Extension extension4 : authorizationParentOrganizationPractitionerRole) {
                this.writeIdentifier("Parent Organization", (Type)extension4, "parent-organization", out);
                this.writeCoding("Organization Role", (Type)extension4, "organization-role", out);
                this.writeCoding("Practitioner Role", (Type)extension4, "practitioner-role", out);
            }
            out.write("</div>\n");
        }
    }

    private void writeCoding(String label, Type type, String url, OutputStreamWriter out) throws IOException {
        Optional<Coding> coding = type.getExtension().stream().filter(e -> url.equals(e.getUrl())).filter(e -> e.getValue() instanceof Coding).map(e -> (Coding)e.getValue()).findFirst();
        if (coding.isPresent()) {
            this.writeRowWithAdditionalRowClasses(label, coding.get().getSystem() + " | <b>" + coding.get().getCode() + "</b>", "nested-row", out);
        }
    }

    private void writeIdentifier(String label, Type type, String url, OutputStreamWriter out) throws IOException {
        Optional<Identifier> identifier = type.getExtension().stream().filter(e -> url.equals(e.getUrl())).filter(e -> e.getValue() instanceof Identifier).map(e -> (Identifier)e.getValue()).findFirst();
        if (identifier.isPresent()) {
            this.writeRowWithAdditionalRowClasses(label, identifier.get().getSystem() + " | <b>" + identifier.get().getValue() + "</b>", "nested-row", out);
        }
    }

    @Override
    public boolean isResourceSupported(URI resourceUri, Resource resource) {
        return resource != null && resource instanceof ActivityDefinition;
    }
}

